% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_autocorrelation.R
\name{obtain_FACF}
\alias{obtain_FACF}
\title{Obtain the autocorrelation function for a given functional time series.}
\usage{
obtain_FACF(Y, v, nlags, ci = 0.95, estimation = "MC", figure = TRUE,
  ...)
}
\arguments{
\item{Y}{Matrix containing the discretized values
of the functional time series. The dimension of the
matrix is \eqn{(n x m)}, where \eqn{n} is the
number of curves and \eqn{m} is the number of points
observed in each curve.}

\item{v}{Discretization points of the curves, by default
\code{seq(from = 0, to = 1, length.out = 100)}.}

\item{nlags}{Number of lagged covariance operators
of the functional time series that will be used
to estimate the autocorrelation function.}

\item{ci}{A value between 0 and 1 that indicates
the confidence interval for the i.i.d. bounds
of the autocorrelation function. By default
\code{ci = 0.95}.}

\item{estimation}{Character specifying the
method to be used when estimating the distribution
under the hypothesis of functional white noise.
Accepted values are:
\itemize{
   \item "MC": Monte-Carlo estimation.
   \item "Imhof": Estimation using Imhof's method.
}
By default, \code{estimation = "MC"}.}

\item{figure}{Logical. If \code{TRUE}, plots the
estimated autocorrelation function with the
specified i.i.d. bound.}

\item{...}{Further arguments passed to the \code{plot_FACF}
function.}
}
\value{
Return a list with:
\itemize{
    \item \code{Blueline}: The upper prediction
    bound for the i.i.d. distribution.
    \item \code{rho}: Autocorrelation values for
    each lag of the functional time series.
}
}
\description{
Estimate the lagged autocorrelation function for a given
functional time series and its distribution under the
hypothesis of strong functional white noise. This graphic tool
can be used to identify seasonal patterns in the functional
data as well as auto-regressive or moving average terms.
i.i.d. bounds are included to test the presence of serial
correlation in the data.
}
\examples{
# Example 1

N <- 100
v <- seq(from = 0, to = 1, length.out = 5)
sig <- 2
Y <- simulate_iid_brownian_bridge(N, v, sig)
obtain_FACF(Y,v,20)

\donttest{
# Example 2

data(elec_prices)
v <- seq(from = 1, to = 24)
nlags <- 30
obtain_FACF(Y = as.matrix(elec_prices), 
v = v,
nlags = nlags,
ci = 0.95,
figure = TRUE)
}
}
\references{
Mestre, G., Portela, J., Muñoz-San Roque, A., Alonso, E. (2020).
\emph{Forecasting hourly supply curves in the Italian Day-Ahead 
electricity market with a double-seasonal SARMAHX model.}
International Journal of Electrical Power & Energy Systems, 
121, 1--13. \url{https://www.sciencedirect.com/science/article/pii/S0142061519337135}

Kokoszka, P., Rice, G., Shang, H.L. (2017).
\emph{Inference for the autocovariance of a functional
 time series under conditional heteroscedasticity}
Journal of Multivariate Analysis, 
162, 32--50. \url{https://www.sciencedirect.com/science/article/pii/S0142061519337135}
}
