% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{create.mesh.3D}
\alias{create.mesh.3D}
\title{Create a \code{mesh.3D} object from the connectivity matrix and nodes locations}
\usage{
create.mesh.3D(
  nodes,
  tetrahedrons,
  order = 1,
  nodesattributes = NULL,
  segments = NULL,
  holes = NULL
)
}
\arguments{
\item{nodes}{A #nodes-by-3 matrix containing the x, y, z coordinates of the mesh nodes.}

\item{tetrahedrons}{A #tetrahedrons-by-4 (when \code{order} = 1) or #tetrahedrons-by-10 (when \code{order} = 2) matrix.
It specifies the tetrahedrons giving the row's indices in \code{nodes} of the tetrahedrons' vertices and (when \code{nodes} = 2) also if the tetrahedrons' edges midpoints. The tetrahedrons' vertices and midpoints are ordered as described
in "The Finite Element Method its Basis and Fundamentals" by O. C. Zienkiewicz, R. L. Taylor and J.Z. Zhu}

\item{order}{Either '1' or '2'. It specifies wether each mesh tetrahedron should be represented by 4 nodes (the tetrahedron's vertices) or by 10 nodes (the tetrahedron's vertices and edge midpoints).
These are
respectively used for linear (order = 1) and quadratic (order = 2) Finite Elements. Default is \code{order} = 1.}

\item{nodesattributes}{A matrix with #nodes rows containing nodes' attributes.
These are passed unchanged to the output. This has been added for consistency with the function \code{create.mesh.2D}.}

\item{segments}{A #segments-by-2 matrix. Each row contains the row's indices in \code{nodes} of the vertices where the segment starts from and ends to.
Segments are edges that are not splitted during the triangulation process. These are for instance used to define the boundaries
of the domain. This has been added for consistency with the function \code{create.mesh.2D}.}

\item{holes}{A #holes-by-3 matrix containing the x, y, z coordinates of a point internal to each hole of the mesh. These points are used to carve holes
in the triangulation, when the domain has holes. This has been added for consistency with the function \code{create.mesh.2D}.}
}
\value{
An object of the class mesh.3D with the following output:
\itemize{
\item{\code{nodes}}{A #nodes-by-3 matrix containing the x, y, z coordinates of the mesh nodes.}
\item{\code{nodesmarkers}}{A vector of length #nodes, with entries either '1' or '0'. An entry '1' indicates that the corresponding node is a boundary node; an entry '0' indicates that the corresponding node is not a boundary node.}
\item{\code{nodesattributes}}{A matrix with #nodes rows containing nodes' attributes.
These are passed unchanged from the input.}
\item{\code{tetrahedrons}}{A #tetrahedrons-by-4 (when \code{order} = 1) or #tetrahedrons-by-10 (when \code{order} = 2) matrix.
It specifies the tetrahedrons giving the indices in \code{nodes} of the tetrahedrons' vertices and (when \code{nodes} = 2) also if the tetrahedrons' edges midpoints.} 
\item{\code{segmentsmarker}}{A vector of length #segments with entries either '1' or '0'. An entry '1' indicates that the corresponding element in \code{segments} is a boundary segment;
an entry '0' indicates that the corresponding segment is not a boundary segment.}
\item{\code{faces}}{A #faces-by-3 matrix containing all the faces of the tetrahedrons in the output triangulation. Each row contains the row's indices in \code{nodes}, indicating the nodes where the face starts from and ends to.}
\item{\code{facesmarkers}}{A vector of lenght #faces with entries either '1' or '0'. An entry '1' indicates that the corresponding element in \code{faces} is a boundary face;
an entry '0' indicates that the corresponding edge is not a boundary face.}
\item{\code{neighbors}}{A #triangles-by-4 matrix. Each row contains the indices of the four neighbouring tetrahedrons An entry '-1' indicates that
one face of the tetrahedrons is a boundary face.}
\item{\code{holes}}{A #holes-by-3 matrix containing the x, y, z coordinates of a point internal to each hole of the mesh. These points are used to carve holes
in the triangulation, when the domain has holes. These are passed unchanged from the input.}
\item{\code{order}}{Either '1' or '2'. It specifies wether each mesh tetrahedron should be represented by 3 nodes (the tetrahedron's vertices) or by 6 nodes (the tetrahedron's vertices and midpoints).
These are respectively used for linear (order = 1) and quadratic (order = 2) Finite Elements.}
}
}
\description{
Create a \code{mesh.3D} object from the connectivity matrix and nodes locations
}
\examples{
library(fdaPDE)

##Load the matrix nodes and tetrahedrons
data(sphere3Ddata)

nodes=sphere3Ddata$nodes
tetrahedrons=sphere3Ddata$tetrahedrons

##Create the triangulated mesh from the connectivity matrix and nodes locations
mesh=create.mesh.3D(nodes,tetrahedrons)
}
