#' fdarep: Two-Dimensional FPCA, Marginal FPCA, and Product FPCA for Repeated Functional Data
#'
#' fdarep for Functional Data Analysis
#'
#' fdarep is a versatile package that provides implementation of various methods
#' of Functional Data Analysis (FDA) for repeated functional data.
#'
#' References: Chen, K., Delicado, P., & Müller, H. G. (2017). Modelling function-valued stochastic processes, with applications to fertility dynamics.
#' Journal of the Royal Statistical Society Series B: Statistical Methodology, 79(1), 177-196.
#' Chen, K., & Müller, H. G. (2012). Modeling repeated functional observations.
#' Journal of the American Statistical Association, 107(500), 1599-1609.
#' Hall, P., Müller, H. G., & Wang, J. L. (2006). Properties of principal component methods for functional and longitudinal data analysis.
#' Yao, F., Müller, H. G., & Wang, J. L. (2005). Functional data analysis for sparse longitudinal data.
#' Journal of the American statistical association, 100(470), 577-590.
#'
#'
#' fdarep is a comprehensive package that directly implements fitting of the following models for repeated functional data:
#' -- Two-dimensional FPCA for dense repeated functional data
#' -- Marginal FPCA for dense repeated functional data
#' -- Product FPCA for dense repeated functional data
#' -- Marginal FPCA for sparse repeated functional data
#' -- Product FPCA for sparse repeated functional data
#'
#'
#' Maintainer:  Poorbita Kundu \email{pkundu@@ucdavis.edu}
#'
#' @author
#' Poorbita Kundu \email{pkundu@@ucdavis.edu}
#' Changbo Zhu
#' Kehui Chen
#' Pedro Delicado
#' Su I Iao
#' Hang Chen
#' Han Chen
#' Muqing Cui
#'
#' Hans-Georg Müller \email{hgmueller@@ucdavis.edu}
#' Jane-Ling Wang \email{janelwang@@ucdavis.edu}
#'
#'
#'
#'
#' @docType package
#' @name fdarep
#' @useDynLib fdarep
#' @import Rcpp
#' @importFrom Matrix Matrix
#' @importFrom Hmisc approxExtrap
#' @importFrom pracma meshgrid midpoint mod ones uniq
#' @importFrom numDeriv grad hessian
#' @importFrom grDevices colorRampPalette dev.new palette
#' @importFrom graphics abline barplot boxplot grid legend lines matlines matplot par plot points polygon
#' @importFrom stats aggregate approx approxfun binomial cov dist fitted glm kmeans lm median na.omit optim predict quantile rnorm runif spline var sd poly weighted.mean cor dunif
#' @importFrom utils head tail
#' @importFrom MASS isoMDS mvrnorm
NULL
