% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic_pcr_regression.R
\name{elastic.pcr.regression}
\alias{elastic.pcr.regression}
\title{Elastic Linear Prinipcal Component Regression}
\usage{
elastic.pcr.regression(f, y, time, pca.method = "combined", no = 5,
  smooth_data = FALSE, sparam = 25, parallel = F, C = NULL)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{y}{vector of size \eqn{M} responses}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{pca.method}{string specifing pca method (options = "combined",
"vert", or "horiz", default = "combined")}

\item{no}{scalar specifify number of principal components (default=5)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}

\item{parallel}{run in parallel (default = F)}

\item{C}{scale balance parameter for combined method (default = NULL)}
}
\value{
Returns a pcr object containing
\item{alpha}{model intercept}
\item{b}{regressor vector}
\item{y}{response vector}
\item{warp_data}{fdawarp object of aligned data}
\item{pca}{pca object of principal components}
\item{SSE}{sum of squared errors}
\item{pca.method}{string specifing pca method used}
}
\description{
This function identifies a regression model with phase-variability
using elastic pca
}
\references{
J. D. Tucker, J. R. Lewis, and A. Srivastava, “Elastic
 Functional Principal Component Regression,” Statistical Analysis and Data
 Mining, 10.1002/sam.11399, 2018.
}
\keyword{alignment}
\keyword{regression}
\keyword{srvf}
