% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_shapes.R
\name{sample_shapes}
\alias{sample_shapes}
\title{Sample shapes from model}
\usage{
sample_shapes(mu, K, mode = "O", no = 3, numSamp = 10)
}
\arguments{
\item{mu}{array (n,T) of mean srvf}

\item{K}{array (2*T,2*T) covariance matrix}

\item{mode}{Open ("O") or Closed ("C") curves}

\item{no}{number of principal components}

\item{numSamp}{number of samples}
}
\value{
samples list of sample curves
}
\description{
Sample shapes from model
}
\examples{
data("mpeg7")
out = curve_karcher_mean(beta[,,1,1:2], maxit=2) # note: use more shapes, small for speed
K = curve_karcher_cov(out$v)
samples = sample_shapes(out$mu, K)
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
