% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.R
\name{boxplot.fdawarp}
\alias{boxplot.fdawarp}
\alias{boxplot.ampbox}
\alias{boxplot.phbox}
\title{Functional Boxplot}
\usage{
\method{boxplot}{fdawarp}(
  x,
  variability_type = c("amplitude", "phase"),
  alpha = 0.05,
  range = 1,
  what = c("plot", "stats", "plot+stats"),
  ...
)

\method{boxplot}{ampbox}(x, ...)

\method{boxplot}{phbox}(x, ...)
}
\arguments{
\item{x}{An object of class \code{fdawarp} typically produced by \code{\link[=time_warping]{time_warping()}}
or of class \code{ampbox} or \code{phbox} typically produced by \code{\link[=boxplot.fdawarp]{boxplot.fdawarp()}}.}

\item{variability_type}{A string specifying which kind of variability should
be displayed in the boxplot. Choices are \code{"amplitude"} or \code{"phase"}.
Defaults to \code{"amplitude"}.}

\item{alpha}{A numeric value specifying the quantile value. Defaults to
\eqn{0.05} which uses the \eqn{95\%} quantile.}

\item{range}{A positive numeric value specifying how far the plot whiskers
extend out from the box. The whiskers extend to the most extreme data point
which is no more than \code{range} times the interquartile range from the box.
Defaults to \code{1.0}.}

\item{what}{A string specifying what the function should return. Choices are
\code{"plot"}, \code{"stats"} or \code{"plot+stats"}. Defaults to \code{"plot"}.}

\item{...}{Unused here.}
}
\value{
If \code{what} contains \code{stats}, a list containing the computed statistics
necessary for drawing the boxplot. Otherwise, the function simply draws the
boxplot and no object is returned.
}
\description{
This function computes the required statistics for building up a boxplot of
the aligned functional data. Since the process of alignment provides
separation of phase and amplitude variability, the computed boxplot can focus
either on amplitude variability or phase variability.
}
\details{
The function \code{\link[=boxplot.fdawarp]{boxplot.fdawarp()}} returns optionally an object of class either
\code{ampbox} if \code{variability_type = "amplitude"} or \code{phbox} if \code{variability_type = "phase"}. \code{S3} methods specialized for objects of these classes are
provided as well to avoid re-computation of the boxplot statistics.
}
\examples{
\dontrun{
out <- time_warping(simu_data$f, simu_data$time)
boxplot(out, what = "stats")
}
}
