% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warp_f_gamma.R
\name{warp_f_gamma}
\alias{warp_f_gamma}
\title{Warp Function}
\usage{
warp_f_gamma(f, time, gamma, spl.int = FALSE)
}
\arguments{
\item{f}{vector function}

\item{time}{time}

\item{gamma}{vector warping function}

\item{spl.int}{use spline interpolation (default F)}
}
\value{
fnew warped function
}
\description{
This function warps function \eqn{f} by \eqn{\gamma}
}
\examples{
fnew <- warp_f_gamma(
  f = simu_data$f[, 1],
  time = simu_data$time,
  gamma = seq(0, 1, length.out = 101)
)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using fisher-rao metric,
arXiv:1103.3817v2.

Tucker, J. D., Wu, W., Srivastava, A.,
Generative Models for Function Data using Phase and Amplitude Separation,
Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
