#' Analysis of Covariance Operators.
#'
#' \code{fdcov} provides a variety of tools for the analysis of 
#' covariance operators.
#'
#' This package contains a collection of tools for performing 
#' statistical inference on functional data specifically through
#' an analysis of the covariance structure of the data.  It includes
#' two methods for performing a k-sample test for equality 
#' of covariance in \code{ksample.perm} and \code{ksample.com}.
#' For supervised and unsupervised learning,
#' it contains a method to classify functional data with 
#' respect to each category's covariance operator in 
#' \code{classif.com}, 
#' and it contains a method to cluster functional data, \code{cluster.com},
#' again based on the covariance structure of the data.
#' 
#' The current version of this package assumes that all functional
#' data is sampled on the same grid at the same intervals.  Future
#' updates are planned to allow for the below methods to interface
#' with the \code{fda} package and its functional basis representations
#' of the data.
#' 
#' @author 
#' Alessandra Cabassi \email{alessandra.cabassi@mail.polimi.it},
#' Adam B Kashlak \email{ak852@cam.ac.uk}
#' @references
#'   Kashlak, Adam B, John AD Aston, and Richard Nickl (2016).
#'   "Inference on covariance operators via concentration
#'   inequalities: k-sample tests, classification, and clustering via
#'   Rademacher complexities", April, 2016 (in review)
#'
#'   Pigoli, Davide, John AD Aston, Ian L Dryden, and Piercesare Secchi. 
#'   "Distances and inference for covariance operators." 
#'   Biometrika (2014): asu008.
#' @importFrom grDevices dev.off postscript setEPS
#' @importFrom stats cov qnorm rbinom rgamma sd
#' @importFrom utils setTxtProgressBar txtProgressBar 
#'
"_PACKAGE"
#> [1] "_PACKAGE"

