% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFailures.R
\name{getFailures}
\alias{getFailures}
\title{Get information on bank failures from FDIC data}
\usage{
getFailures(fields, range = NULL, limit = 10000)
}
\arguments{
\item{fields}{a character vector specifying the fields to include in the
  output.
\describe{
  \item{NAME}{The name of the failed bank}
  \item{CERT}{The FDIC certificate number of the failed bank}
  \item{FIN}{The failed bank's unique financial institution identifier}
  \item{CITYST}{The city and state where the failed bank was located}
  \item{FAILDATE}{The date of the bank failure}
  \item{FAILYR}{The year of the bank failure}
  \item{SAVR}{Whether the failed bank was a savings and loan association}
  \item{RESTYPE}{The type of failed institution}
  \item{RESTYPE1}{A more specific classification of the failed institution}
  \item{CHCLASS1}{The bank's charter class}
  \item{QBFDEP}{The amount of deposits held by the bank at the time of failure}
  \item{QBFASSET}{The total assets held by the bank at the time of failure}
  \item{COST}{The estimated cost to the FDIC of the bank's failure}
  \item{PSTALP}{The FDIC's estimated percentage of insured deposits paid to depositors}
}}

\item{range}{a numeric vector of length 2 specifying the start and end dates
(in YYYY format) for the date range to include. If not specified, all
failures will be included.}

\item{limit}{an integer specifying the maximum number of results to return.
Defaults to 10,000.}
}
\value{
a data frame containing the requested fields for each bank failure
  within the specified date range (if applicable).
}
\description{
This function retrieves information on bank failures from the FDIC data
API, using the specified fields and (optional) date range. If a date range is
specified, only failures within that range will be included.
}
\examples{
df <- getFailures(c("CERT", "NAME", "FAILDATE", "CITY", "STATE"), range = c(2010, 2015))
head(df)
}
