% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{ADABOOST}
\alias{ADABOOST}
\title{Classification using AdaBoost}
\usage{
ADABOOST(x, y, learningmethod, nsamples = 100, fuzzy = FALSE,
  tune = FALSE, seed = NULL, ...)
}
\arguments{
\item{x}{The dataset (description/predictors), a \code{matrix} or \code{data.frame}.}

\item{y}{The target (class labels or numeric values), a \code{factor} or \code{vector}.}

\item{learningmethod}{The boosted method.}

\item{nsamples}{The number of samplings.}

\item{fuzzy}{Indicates whether or not fuzzy classification should be used or not.}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{seed}{A specified seed for random number generation.}

\item{...}{Other specific parameters for the leaning method.}
}
\value{
The classification model.
}
\description{
Ensemble learning, through AdaBoost Algorithm.
}
\examples{
require (datasets)
data (iris)
ADABOOST (iris [, -5], iris [, 5], NB)
}
\seealso{
\code{\link{BAGGING}}, \code{\link{predict.boosting}}
}
