% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{SOM}
\alias{SOM}
\title{Self-Organizing Maps clustering method}
\usage{
SOM(d, xdim = floor(sqrt(nrow(d))), ydim = floor(sqrt(nrow(d))),
  rlen = 10000, post = c("none", "single", "ward"), k = NULL, ...)
}
\arguments{
\item{d}{The dataset (\code{matrix} or \code{data.frame}).}

\item{xdim, ydim}{The dimensions of the grid.}

\item{rlen}{The number of iterations.}

\item{post}{The post-treatement method: \code{"none"} (None), \code{"single"} (Single link) or \code{"ward"} (Ward clustering).}

\item{k}{The number of cluster (only used if \code{post} is different from \code{"none"}).}

\item{...}{Other parameters.}
}
\value{
The fitted Kohonen's map as an object of class \code{som}.
}
\description{
Run the SOM algorithm for clustering.
}
\examples{
require (datasets)
data (iris)
SOM (iris [, -5], xdim = 5, ydim = 5, post = "ward", k = 3)
}
\seealso{
\code{\link{plot.som}}, \code{\link{som-class}}, \code{\link[kohonen]{som}}
}
