% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{augmentation}
\alias{augmentation}
\title{Duplicate and add noise to a dataset}
\usage{
augmentation(dataset, target, n = 5, sigma = 0.1, seed = NULL)
}
\arguments{
\item{dataset}{The dataset to be split (\code{data.frame} or \code{matrix}).}

\item{target}{The column index of the target variable (class label or response variable).}

\item{n}{The scaling factor (as an integer value).}

\item{sigma}{The baseline variance for the noise generation.}

\item{seed}{A specified seed for random number generation.}
}
\value{
An augmented dataset.
}
\description{
This function is a data augmentation technique. It duplicates rows and add gaussian noise to the duplicates.
}
\examples{
require (datasets)
data (iris)
d = augmentation (iris, 5)
summary (iris)
summary (d)
}
