% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphology.R
\name{morphology}
\alias{morphology}
\title{Soil morphology}
\usage{
morphology(x, variable = "color")
}
\arguments{
\item{x}{Character string with field soil morphology description (in Portuguese).}

\item{variable}{Character string defining the soil morphological property of interest. Options:
\code{color}, \code{structure}, \code{consistence}.}
}
\value{
An object of class \code{data.frame}.
}
\description{
Extract and process soil morphological properties from field soil morphology
descriptions.
}
\examples{
\donttest{
horizons <- layer(data.set = "ctb0025", variable = "morfologia_descricao")
color <- morphology(x = horizons$morfologia_descricao, variable = "color")
structure <- morphology(x = horizons$morfologia_descricao, variable = "structure")
consistence <- morphology(x = horizons$morfologia_descricao, variable = "consistence")
}
x <- "cinzento rosado (7.5YR 6/2, seco), bruno escuro (7.5YR 3/2, úmido)"
color <- morphology(x = x, variable = "color")
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
