% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangle_ellipse.R
\name{wrangle_ellipse}
\alias{wrangle_ellipse}
\title{Ellipse Wrangeler}
\usage{
wrangle_ellipse(ell, out_params = c("c", "P", "r"))
}
\arguments{
\item{ell}{a list of (non degenerate) ellipses to be wrangled. An ellipse is
a named list and each entry corresponds to a parameter. To ensure all
\code{out_params} can be calculated one of the parametrizations listed
below in the description must be specified. Some \code{out_params} do
not require a fully parametrized ellipse and so partially specified
ellipses can be used.}

\item{out_params}{a vector of names of the output parameters. A list of
possible parameters is given below in the details.}
}
\value{
A list of wrangled ellipses. The wrangled ellipses are now given by
  the \code{out_params}.
}
\description{
\code{wrangle_ellipse} is used to wrangle one or more ellipses from one
parametrization to another.
}
\details{
Takes ellipse parameters and and calculates the wanted \code{out_params}. A
parameterization is a named list, where each named entry is a parameter. The
following parameters are accepted both input and output:

\itemize{
  \item{\code{n} : }{ dimension of ellipse; an integer.}
  \item{\code{c} : }{ center of the ellipse; a vector.}
  \item{\code{P} : }{ precision matrix - inverse of \code{S}; a positive
    definit, symmetric matrix.}
  \item{\code{S} : }{ deviation matrix - inverse of \code{P}; a positive
    definit, symmetric matrix.}
 \item{\code{r} : }{ radius; a positive number.}
 \item{\code{q} : }{ cross term \code{-Pc}; a vector.}
 \item{\code{L} : }{ Cholesky decomposition of \code{P}}
 \item{\code{e} : }{ eigen values of \code{P}; a vector of eigenvalues.}
 \item{\code{U} : }{ eigen vectors of \code{P}; a matrix, where each column
   is an eigen vector.}
 \item{\code{D} : }{ diagnonal matrix with \code{sqrt(e)} as diagonal entries.}
}

An ellipse \code{E} may be fully parameterized using the above parameters in
the following ways:
\ifelse{html}{\out{<center>E = { x &#8712 R<sup>p</sup> :  (x - c)<sup>T</sup> P (x - c) &#8804 r }</center>}}{\deqn{E = \{x \in \R^p: (x-c)^T P (x-c) \leq r\}}}
\ifelse{html}{\out{<center>E = { x &#8712 R<sup>p</sup> :  (x - c)<sup>T</sup> S<sup>-1</sup> (x - c) &#8804 r }</center>}}{\deqn{E = \{x \in \R^p: (x-c)^T S^{-1} (x-c) \leq r\}}}
\ifelse{html}{\out{<center>E = { x &#8712 R<sup>p</sup> :  (x - c)<sup>T</sup> LL<sup>T</sup> (x - c) &#8804 r }</center>}}{\deqn{E = \{x \in \R^p: (x-c)^T LL^T (x-c) \leq r\}}}
\ifelse{html}{\out{<center>E = { x &#8712 R<sup>p</sup> :  (x - c)<sup>T</sup> UD<sup>2</sup>U<sup>T</sup> (x - c) &#8804 r }</center>}}{\deqn{E = \{x \in \R^p: (x-c)^T UD^2U^T (x-c) \leq r\}}}
\ifelse{html}{\out{<center>E = { x &#8712 R<sup>p</sup> :  || L<sup>T</sup>(x - c) ||<sub>2</sub> &#8804 r }</center>}}{\deqn{E = \{x \in \R^p: ||L^T(x-c)||_2 \leq r\}}}
\ifelse{html}{\out{<center>E = { x &#8712 R<sup>p</sup> :  || DU<sup>T</sup>(x - c) ||<sub>2</sub> &#8804 r }</center>}}{\deqn{E = \{x \in \R^p: ||DU^T(x-c)||_2 \leq r\}}}
\ifelse{html}{\out{<center>E = { x &#8712 R<sup>p</sup> :  c + L<sup>-T</sup>w, ||w|| &#8804 r }</center>}}{\deqn{E = \{x \in \R^p: c + L^{-T}w, \ ||w|| \leq r\}}}
\ifelse{html}{\out{<center>E = { x &#8712 R<sup>p</sup> :  c + UD<sup>-1</sup>w, ||w|| &#8804 r }</center>}}{\deqn{E = \{x \in \R^p: c + UD^{-1}w, \ ||w|| \leq r\}}}

To ensure that all of the above parameters can be calculated it is advised
(but in some cases not needed) that the input ellipses are fully
parameterized.
}
\examples{
# two dimensional unite ball
e2d <- list(c = c(0,0), S = matrix(c(1,0,0,1), ncol = 2), r = 1)

# three dimensional ellipse
e3d <- list(c = c(3,2,1), P = matrix(c(3,1,2,1,5,0,2,0,2), ncol = 3))

f1 <- wrangle_ellipse(e2d) # (c,P,r) parameterization
f2 <- wrangle_ellipse(e2d, out_params = c("c", "e", "U", "r"))
f3 <- wrangle_ellipse(list("ellipse1" = e2d, "ellipse2" = e3d),
                      c("n", "c", "U", "D"))

}
