\name{Sensitivity}
\alias{read.pcv}
\alias{plot.pcv}
\alias{points.pcv}
\alias{summary.pcv}
\alias{collin.remove}
\alias{collin.format.table}
\alias{dmabs}
\alias{dmsqr}
\alias{print.pcv}

\title{Parameter covariance output}
\description{
  Using Application=Parcovariance in FEMME a .PCV file is generated which
  can be read and further processed with these functions
}

\usage{
read.pcv(pcvfile)

## sensitivity analysis

summary.pcv(object, parnames = NULL,order=TRUE,...)

plot.pcv(x,xvar=seq(along=sens.data[,1]),ylim=NULL,pari=seq(1,length(x$sens)-4),parnames=NULL,type='b',scale=FALSE,...)

points.pcv(x,xvar=seq(along=sens.data[,1]),pari=1,type='b',...)

## Collinearity tables

collin.format.table(x, parnames = NULL)

collin.remove(x, pari)
}

\arguments{
  \item{pcvfile}{File ending in .pcv generated by FEMME}
  \item{x}{object of class pcv created by \code{read.pcv}}
  \item{object}{object of class pcv created by \code{read.pcv}}
  \item{ylim}{Limits of the Y axis}
  \item{parnames}{Parameter names}
  \item{order}{Order parameters in decreasing importance}
   \item{xvar}{Variable such as time or depth}
  \item{pari}{Vector of parameter index}
   \item{scale}{A logical value indicating if Y axis should be common to
    all parameters}
  \item{type}{Plot type}
  \item{...}{Additional plot parameters}
}
\details{
\code{plot.pcv} plots by default the sensitivity functions of all
parameters. You can also specify to plot only a single parameter.

Adding a second set of sensitivities can be done with \code{points.pcv}
}
\value{
\code{read.pcv} returns a list with components
  \item{sens}{Relative sensitivity of parameters at observed data points}
  \item{collin}{Collinearity index for all possible parameter combinations}
  ...
}
\references{Soetaert et al, 2002, Ecological  Modelling 151: 177-193,
  Brun et al, 2001, Water Resources Research 37: 1015-1030}
\author{Henrik Andersson <h.andersson@nioo.knaw.nl>}
\note{Use at your own risk}


\examples{


## For examples see: vignette("femmeR")

}

\keyword{file}
\keyword{misc}
\keyword{hplot}

