\name{TIMEZEROD}
\alias{read.o1}
\alias{plot.o1}
\alias{print.o1}

\title{Time depdendent 0-d output}
\description{
  Time-varying, Zero-dimensional variables are stored by FEMME in a .o1 file which
  can be read and further processed with these functions
}

\usage{
read.o1(o1file)

plot.o1(x,xvari=1,yvari=2,rev="",type='l',obs=NULL,pch=16,
        main=x$filename,xlab=NULL,ylab=NULL,xlim=NULL,ylim=NULL,
        mar=NULL,oma=NULL,obsname=obs$filename,...)

}

\arguments{
  \item{o1file}{File ending in .st1 generated by FEMME}
  \item{x}{object of class st1 created by \code{read.o1}}
  \item{xvari}{Index of X Variable}
  \item{yvari}{Index of Y Variable}
  \item{rev}{Reversion of axis}
  \item{obs}{Observation object created by \code{read.obs}}
  \item{obsname}{Name of observation for title}
  \item{main}{Main title}
  \item{xlab}{X axis label}
  \item{ylab}{Y axis label}
  \item{xlim}{Limits of the X axis}
  \item{ylim}{Limits of the Y axis}
  \item{mar}{Inner margins}
  \item{oma}{Outer margins}
  \item{type}{Plot type}
  \item{pch}{Plotting character}
  \item{...}{Additional plot parameters}
}
\details{

}
\value{
\code{read.o1} returns a list with components
\item{data}{Modelled data}
\item{vars}{Variable names}
\item{units}{Variable units}
\item{filename}{Filename}
}
\references{Soetaert et al, 2002}
\author{Henrik Andersson <h.andersson@nioo.knaw.nl>}
\note{Use at your own risk}

\seealso{\code{\link{read.obs}}}
\examples{
## For examples see: vignette("femmeR")


## test.st1 <- read.st1("blaha.st1")
## plot(test.st1)



}

\keyword{file}
\keyword{misc}
\keyword{hplot}

