% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{add_space}
\alias{add_space}
\title{A ggproto for drawing circle}
\usage{
add_space(
  dt,
  space_alpha = 0.5,
  space_fill = "grey92",
  space_color = "white",
  cent_size = 1,
  cent_alpha = 1,
  cent_color = "black",
  ...
)
}
\arguments{
\item{dt}{A data object from the running the optimisation algorithm in guided tour}

\item{space_alpha}{numeric; the alpha of the basis space}

\item{space_fill}{character; the colour of the space filling}

\item{space_color}{character; the colour of the space brim}

\item{cent_size}{numeric; the size of the centre point}

\item{cent_alpha}{numeric; an alpha of the centre point}

\item{cent_color}{character; the colour of the centre point}

\item{...}{other aesthetics inherent from \code{explore_space_pca()}}
}
\value{
a wrapper for drawing the space in \code{explore_space_pca()}
}
\description{
This is  a wrapper function used by \code{explore_space_pca()} and
should be be called directly by the user
}
\examples{
library(ggplot2)
space <- tibble::tibble(x0 = 0, y0 = 0, r = 5)
ggplot() +
  add_space(space) +
  theme_void() +
  theme(aspect.ratio = 1)
}
\seealso{
Other draw functions: 
\code{\link{add_anchor}()},
\code{\link{add_anno}()},
\code{\link{add_dir_search}()},
\code{\link{add_end}()},
\code{\link{add_interp}()},
\code{\link{add_interp_last}()},
\code{\link{add_interrupt}()},
\code{\link{add_search}()},
\code{\link{add_start}()},
\code{\link{add_theo}()}
}
\concept{draw functions}
