% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffl-api.R
\name{ffl_api}
\alias{ffl_api}
\title{Return list data from API JSON}
\usage{
ffl_api(lid = getOption("lid"), old = FALSE, view = NULL, ...)
}
\arguments{
\item{lid}{ESPN League ID, defaults to \code{getOption("lid")}. Use
\verb{options(lid = <League ID>)} to set your league ID; put that line in your
\code{.Rprofile} file to set the option at start up.}

\item{old}{If \code{FALSE} (default), return only the current season's data. If
\code{TRUE}, return a list with all prior seasons.}

\item{view}{The API "view" for data to be returned.}

\item{...}{Additional API query arguments. Use "week" and "year" as a
shorthand for "ScoringPeriodId" and "seasonId" respectively.}
}
\description{
A generic call to the API using \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} with nested data
set to simplify. Use "week" and "year" as shortcuts for "scoringPeriodId"
and "seasonId" respectively. Setting \code{old} equal to \code{TRUE} uses the
"leagueHistory" API instead of accessing 2020 season data.
}
