% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mfl_draft.R, R/sleeper_draft.R
\name{ff_draft}
\alias{ff_draft}
\alias{ff_draft.mfl_conn}
\alias{ff_draft.sleeper_conn}
\title{Get Draft Results}
\usage{
ff_draft(conn, ...)

\method{ff_draft}{mfl_conn}(conn, custom_players = FALSE, ...)

\method{ff_draft}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}

\item{...}{args for other methods}

\item{custom_players}{MFL: TRUE or FALSE - retrieve custom players from the MFL database? (Allows for devy, placeholder picks, slightly slower)}
}
\value{
A tidy dataframe of draft results
}
\description{
This function gets a tidy dataframe of draft results for the current year.
Can handle MFL devy drafts or startup drafts by specifying the custom_players argument
}
\section{Methods (by class)}{
\itemize{
\item \code{mfl_conn}: MFL: returns a table of drafts for the current year - can handle devy/startup-rookie-picks by specifying custom_players (slower!)

\item \code{sleeper_conn}: Sleeper: returns a dataframe of all drafts and draft selections, if available.
}}

\examples{
\donttest{
ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
ff_draft(ssb_conn)
}

\donttest{
jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
ff_draft(jml_conn)
}

}
