% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_matches.R
\name{rename_matches}
\alias{rename_matches}
\title{Rename an object based on case-insensitive match of the names of a reference.}
\usage{
rename_matches(x, y)
}
\arguments{
\item{x}{x object which names to restored if they match the reference.}

\item{y}{Named object to use as reference.}
}
\value{
The output is \code{x} with as many names changed as case-insensitive
matches there are with the reference.
}
\description{
Rename an object based on case-insensitive match of the names of a reference.
}
\examples{
ref <- data.frame(COL1 = 1, COL2 = 1)
x <- data.frame(col1 = 5, col2 = 1, n = 5)
rename_matches(x, ref)
}
\seealso{
Other functions for developers: \code{\link{check_crucial_names}},
  \code{\link{extract_insensitive}},
  \code{\link{flag_if_group}}, \code{\link{is_multiple}},
  \code{\link{nms_try_rename}}, \code{\link{type_ensure}}

Other general functions to deal with names: \code{\link{extract_insensitive}}
}
\concept{functions for developers}
\concept{general functions to deal with names}
\keyword{internal}
