% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_if_group.R
\name{flag_if_group}
\alias{flag_if_group}
\alias{detect_if_group}
\title{Detect and flag based on a predicate applied to a variable by groups.}
\usage{
flag_if_group(.data, name, predicate, condition = warn, msg = NULL)

detect_if_group(.data, name, predicate)
}
\arguments{
\item{.data}{A dataframe.}

\item{name}{String. The name of a column of the dataframe.}

\item{predicate}{A predicate function, e.g. \code{\link[=is_multiple]{is_multiple()}}.}

\item{condition}{A condition function, e.g. \code{\link[rlang:inform]{rlang::inform()}} or
\code{\link[base:stop]{base::stop()}}.}

\item{msg}{String to customize the returned message.}
}
\value{
\itemize{
\item \code{flag_if_group()}: A condition and its first input, invisibly.
\item \code{detect_if_group()}: Logical of length 1.
}
}
\description{
These functions extend \code{flag_if()}] and \code{detect_if()} to
work by groups defined with \code{\link[dplyr:group_by]{dplyr::group_by()}}.
}
\examples{
tree <- tibble(CensusID = c(1, 2), treeID = c(1, 2))
detect_if_group(tree, "treeID", is_multiple)
flag_if_group(tree, "treeID", is_multiple)

by_censusid <- group_by(tree, CensusID)
detect_if_group(by_censusid, "treeID", is_multiple)
flag_if_group(by_censusid, "treeID", is_multiple)
}
\seealso{
Other functions to check inputs: 
\code{\link{check_crucial_names}()},
\code{\link{is_multiple}()}

Other functions for developers: 
\code{\link{check_crucial_names}()},
\code{\link{extract_insensitive}()},
\code{\link{is_multiple}()},
\code{\link{nms_try_rename}()},
\code{\link{rename_matches}()},
\code{\link{type_ensure}()}
}
\concept{functions for developers}
\concept{functions to check inputs}
\concept{predicates}
\keyword{internal}
