% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_resources.R
\name{fhir_sample_resources_by_ids}
\alias{fhir_sample_resources_by_ids}
\title{Download a random sample of resources from a vector of resource IDs.}
\usage{
fhir_sample_resources_by_ids(
  base_url,
  resource,
  ids,
  id_param = "_id",
  username = NULL,
  password = NULL,
  token = NULL,
  add_headers = NULL,
  sample_size = 20,
  seed = 1,
  verbose = 1
)
}
\arguments{
\item{base_url}{A character vector of length one specifying the base URL of the FHIR server, e.g. \code{"http://hapi.fhir.org/baseR4"}.}

\item{resource}{A character vector of length one or \linkS4class{fhir_resource_type} object with the resource type to be downloaded e.g. \code{"Patient"}.}

\item{ids}{A character vector containing the IDs from which to sample.}

\item{id_param}{A character vector of length one containing the FHIR Search parameter belonging to the ids in \code{ids}. Defaults to \code{"_id"} meaning \code{ids} is interpreted as
containing resource (aka logical) ids. Could be changed to \code{"identifier"} if \code{ids} contains a vector of identifier values instead.}

\item{username}{A character vector of length one containing the username for basic authentication.}

\item{password}{A character vector of length one containing the password for basic authentication.}

\item{token}{A character vector of length one or object of class \link[httr:Token-class]{httr::Token}, for bearer token authentication (e.g. OAuth2). See \code{\link[=fhir_authenticate]{fhir_authenticate()}}
for how to create this.}

\item{add_headers}{A named character vector of custom headers to add to the HTTP request, e.g. \code{c(myHeader = "somevalue")} or
\code{c(firstHeader = "value1", secondHeader = "value2")}.}

\item{sample_size}{A integer of length 1 containing the number of resources to sample.}

\item{seed}{A integer of length 1 containing the seed for the random generator.}

\item{verbose}{An integer of length 1 containing the level of verbosity. Defaults to 1.}
}
\value{
A list of bundles containing sampled resources.
}
\description{
Download a random sample of resources from a vector of resource IDs.
}
\details{
This function takes a character vector \code{ids} containing logical Ids of resources of a given type (specified in \code{resource}) on a
FHIR server (specified in \code{base_url}) and downloads a random sample of size \code{sample_size} of the corresponding resources from the server.

Internally, the download of the resources is done by \code{\link[=fhir_get_resources_by_ids]{fhir_get_resources_by_ids()}}. This function will attempt to download the resources using a
FHIR search request via POST where the IDs are part of the body. See \code{\link[=fhir_search]{fhir_search()}} for details. If this fails
(e.g. because the server doesn't allow POST operations), the function falls back on a GET request. If the set of IDs is too long to fit
into one GET request (i.e. if the request gets longer than 2083 characters), it will be spread across several requests.

For more information on authentication options, please see the help page of `\code{\link[=fhir_search]{fhir_search()}}
}
\examples{
\donttest{

#the try({}, silent = TRUE) statement is only there to catch errors when the server is down
#you can skip it when the server is reachable

try({

#find IDs of all resources representing Homer Simpson
ids <- fhir_get_resource_ids(
  base_url   = 'https://hapi.fhir.org/baseR4',
  resource   = "Patient",
  parameters = "name=Homer&name=Simpson")

#Sample 10 of them
bundles <- fhir_sample_resources_by_ids(
  base_url    = 'https://hapi.fhir.org/baseR4',
  resource    = "Patient",
  ids         = ids,
  sample_size = 10,
  seed        = 1)

#Have a look at the samples
fhir_crack(
  bundles,
  fhir_table_description(
    resource = "Patient",
    cols     = list(
      ID     = "id",
      given  = "name/given",
      family = "name/family")))

}, silent = TRUE)
}
}
\seealso{
\code{\link[=fhir_search]{fhir_search()}}, \code{\link[=fhir_sample_resources]{fhir_sample_resources()}}, \code{\link[=fhir_get_resources_by_ids]{fhir_get_resources_by_ids()}}, \code{\link[=fhir_count_resource]{fhir_count_resource()}}
}
