% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.formula.R
\name{make.formula}
\alias{make.formula}
\title{Convert strings to a formula}
\usage{
make.formula(response, predictors, random = NULL)
}
\arguments{
\item{response}{a single string used on the left side of a formula}

\item{predictors}{a string (or a vector of strings) representing the predictors. Each will be separated by a plus sign.}

\item{random}{a string that indicates the random component in an \code{lmer}-like object (e.g., "(1|group)"). Defaults
to NULL.}
}
\value{
a formula object
}
\description{
\code{make.formula} is a function that easily converts a set of strings into a formula. It requires two arguments: a single response variable,
and a vector of strings. See examples.
}
\examples{
k = data.frame(matrix(rnorm(100), ncol=5))
names(k) = LETTERS[1:5]
formula = make.formula("A", LETTERS[2:5])
formula
lm(formula, data=k)
#do a random model
make.formula("A", LETTERS[2:5], random="(1|group)")
}
\author{
Dustin Fife
}

