% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs2meco.R
\name{vs2meco}
\alias{vs2meco}
\title{Transform viromescan results to 'microtable' object.}
\usage{
vs2meco(input_dir, sample_table = NULL, match_table = NULL, ...)
}
\arguments{
\item{input_dir}{the input directory, containing all the result folders for each sample. Each folder should be named by the sample name.}

\item{sample_table}{default NULL; sample metadata table; If provided, must be one of the several types of formats:\cr
1) comma seperated file with the suffix csv or tab seperated file with suffix tsv/txt;\cr
2) Excel type file with the suffix xlsx or xls; require \code{readxl} package to be installed;\cr
3) \code{data.frame} object from R.}

\item{match_table}{default NULL; a two column table used to replace the sample names in abundance table; Must be two columns without column names;
The first column must be raw sample names same with those in feature table, 
the second column must be new sample names same with the rownames in sample_table; Please also see the example files.}

\item{...}{parameter passed to microtable$new function of microeco package, such as auto_tidy parameter.}
}
\value{
microtable object.
}
\description{
Transform the results of viromescan software to microtable object.
The output of viromescan is single file for each sample.
All the results are needed to be merged and adjusted (for several chaotic taxonomy).
The input should be the 'count' tables at Species level, i.e. Species_level_results-Counts.txt.
For more details, please see the reference <DOI: 10.1186/s12864-016-2446-3>.
}
\examples{
\donttest{
library(microeco)
library(file2meco)
# use viromescan directory inside the package
dir_path <- system.file("extdata", "viromescan", package="file2meco")
d1 <- vs2meco(dir_path)
d1$cal_abund()
# d1$taxa_abund$Family is same with the percentage output of viromescan at 
# Family level, i.e. Family_level_results-\%.txt file
d1$cal_abund(rel = FALSE)
# d1$taxa_abund$Family is same with the count output of viromescan at 
# Family level, i.e. Family_level_results-Counts.txt file
}
}
