% Generated by roxygen2 (4.0.2): do not edit by hand
\name{insert}
\alias{insert}
\alias{insert.character}
\alias{insert.filename}
\title{Insert tag or extension into a file name}
\usage{
insert(x, ...)

\method{insert}{filename}(x, tag = NULL, tag.pos = NULL, ext = NULL,
  ext.pos = NULL, replace = FALSE, ...)

\method{insert}{character}(x, ...)
}
\arguments{
\item{x}{file name (\code{character} or \code{filename})}

\item{...}{unused arguments}

\item{tag}{one or more file name tags to insert}

\item{tag.pos}{position at which to insert tag
(\code{NULL}: append at the end or replace tag)}

\item{ext}{one or more file extension tags to insert}

\item{ext.pos}{position at which to insert extension
(\code{NULL}: insert at penultimate position)}

\item{replace}{if \code{TRUE}, tag or extension is replaced
(default: replace last tag)}
}
\value{
modified object of the original type
}
\description{
This function inserts a tag or extension into a file name.
It can also replace an element of a file name.
}
\details{
By default, tags are inserted at the ultimate position and extensions
at the penultimate position, if possible.
(That is, the final file extension will not change, unless the insertion
position is specified otherwise or the orginal file name had no extension.)
If \code{replace} is \code{TRUE}, the tag at the indicated position is
replaced by the new tag instead.
}
\examples{
f <- as.filename("data_expr_2014-05-01.tsv")

# new file name with inserted tags for saving normalized data
g <- insert(f, tag=c("mod", "norm"))
print(as.character(g))

# new file name with inserted extension for saving sorted data
h <- insert(f, ext="sorted")
print(as.character(h))

# new file name with different extension for saving in different format
i <- insert(f, ext="csv", replace=TRUE)
print(as.character(i))

# insert another tag
j <- insert(g, tag="qc", tag.pos=2)
print(as.character(j))
}

