% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryfactorlist4.R
\name{summary_factorlist4}
\alias{summary_factorlist4}
\title{Summarise a set of factors by a dependent variable}
\usage{
summary_factorlist4(.data, dependent, explanatory, cont = "mean", p = FALSE,
  na_include = FALSE, column = FALSE, total_col = FALSE,
  orderbytotal = FALSE, fit_id = FALSE, na_to_missing = TRUE,
  add_dependent_label = FALSE, dependent_label_prefix = "Dependent: ",
  dependent_label_suffix = "")
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector of length 1:  name of depdendent variable
(2 to 5 factor levels).}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{cont}{Summary for continuous variables: mean (standard deviation) or
median (interquartile range).}

\item{p}{Logical: Include statistical test (see
\code{\link[Hmisc]{summary.formula}}).}

\item{na_include}{Logical: include missing data in summary (\code{NA}).}

\item{column}{Logical: Compute margins by column rather than row.}

\item{total_col}{Logical: include a total column summing across factor
levels.}

\item{orderbytotal}{Logical: order final table by total column high to low.}

\item{fit_id}{Logical: not used directly, allows merging via
\code{\link{finalfit_merge}}.}

\item{na_to_missing}{Logical: convert \code{NA} to 'Missing' when
\code{na_include=TRUE}.}

\item{add_dependent_label}{Add the name of the dependent label to the top
left of table}

\item{dependent_label_prefix}{Add text before dependent label}

\item{dependent_label_suffix}{Add text after dependent label}
}
\value{
Returns a \code{factorlist} dataframe.
}
\description{
Internal function, not called directly.
}
\keyword{internal}
