% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_newdata.R
\name{ff_mode}
\alias{ff_mode}
\alias{finalfit_mode}
\title{Return the most frequent level in a factor}
\usage{
ff_mode(...)

finalfit_mode(...)
}
\arguments{
\item{...}{Unquoted factor names.}
}
\value{
The most frequent level in a factor.
}
\description{
When producing conditional estimates from a regression model, it is often useful
to set variables not of interest to their mode when creating the newdata object.
}
\examples{
library(dplyr)
colon_s \%>\% 
  summarise(age.factor = ff_mode(age.factor))
  
colon_s \%>\% 
  select(sex.factor, rx.factor, obstruct.factor, perfor.factor) \%>\% 
  summarise(across(everything(), ff_mode))
  
colon_s \%>\% 
  reframe(across(where(is.factor), ff_mode))
  # Note, 4 rows is returned in this example because 4 factor levels within `hospital` 
  # have the same frequency. 
}
\seealso{
\code{\link{summary_df}} \code{\link{ff_expand}}
}
