% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{commercial_electricity_flow_FI_to_SE3}
\alias{commercial_electricity_flow_FI_to_SE3}
\title{Commercial electricity flow between Finland and Mid Sweden (FI-SE3)}
\usage{
commercial_electricity_flow_FI_to_SE3(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains commercial electricity flow
(dayahead market and intraday market) between Finland (FI) and Central
Sweden (SE3). Positive sign is export from Finland to Sweden.
}
\description{
Check https://data.fingrid.fi/en/dataset/commercial-flow-fi-se3
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- commercial_electricity_flow_FI_to_SE3(start_time = start,
                                            end_time = end,
                                            user_key = key)
summary(df)
}
}
