% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{transmission_Aland_to_SE_RTD}
\alias{transmission_Aland_to_SE_RTD}
\title{Transmission between Sweden and Åland - real time data}
\usage{
transmission_Aland_to_SE_RTD(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains power transmission between Åland
and Sweden based on the real-time measurements in Fingrid's operation
control system. Åland is a part of SE3 (Central-Sweden) bidding zone.
Positive sign means transmission from Åland to Sweden. Negative sign
means transmission from Sweden to Åland. The data is updated every 3
minutes.
}
\description{
Check https://data.fingrid.fi/en/dataset/transmission-between-sweden-and-aland-real-time-data
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- transmission_Aland_to_SE_RTD(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
