% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_get_unique_ngrams}
\alias{fst_get_unique_ngrams}
\title{Get unique n-grams}
\usage{
fst_get_unique_ngrams(table1, table2, ...)
}
\arguments{
\item{table1}{The first table.}

\item{table2}{The second table.}

\item{...}{Any other tables you want to include.}
}
\value{
Dataframe of words and whether word is unique or not.
}
\description{
Takes at least two tables of n-grams and frequencies (either output of
`fst_get_top_words()` or `fst_get_top_ngrams()`) and finds n-grams unique to
 one table.
}
\examples{
top_f <- fst_get_top_words(conllu_dev_q11_1_f_nltk)
top_m <- fst_get_top_words(conllu_dev_q11_1_m_nltk)
top_na <- fst_get_top_words(conllu_dev_q11_1_na_nltk)
topn_f <- fst_get_top_ngrams(conllu_dev_q11_1_f_nltk)
topn_m <- fst_get_top_ngrams(conllu_dev_q11_1_m_nltk)
topn_na <- fst_get_top_ngrams(conllu_dev_q11_1_na_nltk)
fst_get_unique_ngrams(top_f, top_m, top_na)
fst_get_unique_ngrams(topn_f, topn_m, topn_na)
}
