% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fish_pallette.R
\name{fish}
\alias{fish}
\alias{fish_pal}
\title{fish Colour Map.}
\usage{
fish(
  n,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Centropyge_loricula"
)

fish_pal(
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Centropyge_loricula"
)
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in [0,1] at which the fish colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the fish colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are ordered from darkest to lightest. If -1, the order of colors is reversed.}

\item{option}{A character string indicating the fish species to use.}
}
\value{
\code{fish} returns a character vector, \code{cv}, of color hex
codes. This can be used either to create a user-defined color palette for
subsequent graphics by \code{palette(cv)}, a \code{col =} specification in
graphics functions or in \code{par}.



Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
devices: see \code{\link[grDevices]{rgb}}.
}
\description{
This function creates a vector of \code{n} equally spaced colors along the
'fish colour map' of your selection
}
\examples{
library(ggplot2)
library(fishualize)

dat <- data.frame(x = rnorm(1e4), y = rnorm(1e4))
ggplot(dat, aes(x = x, y = y)) +
  stat_density_2d(geom = "raster",
  aes(fill = after_stat(density)), contour = FALSE) +
  scale_fill_gradientn(colors = fish(128, option = 'Ostracion_cubicus'))

pal <- fish(256, option = "Thalassoma_hardwicke", direction = -1)
image(volcano, col = pal)

}
