% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BetaCorrBin.R
\name{pBetaCorrBin}
\alias{pBetaCorrBin}
\title{Beta-Correlated  Binomial Distribution}
\usage{
pBetaCorrBin(x,n,cov,a,b)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{n}{single value for no of binomial trials.}

\item{cov}{single value for covariance.}

\item{a}{single value for alpha parameter}

\item{b}{single value for beta parameter.}
}
\value{
The output of \code{pBetaCorrBin} gives cumulative probability  values in vector form.
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the Beta-Correlated  Binomial Distribution.
}
\details{
The probability function and cumulative function can be constructed and are denoted below

The cumulative probability function is the summation of probability function values.

\if{html}{\figure{Capture.png}{options: width="50\%"}}
\if{latex}{\figure{Capture.png}{options: width=11cm}}

\deqn{x = 0,1,2,3,...n}
\deqn{n = 1,2,3,...}
\deqn{-\infty < cov < +\infty }
\deqn{0< a,b}
\deqn{0 < p < 1}

\deqn{p=\frac{a}{a+b}}
\deqn{\Theta=\frac{1}{a+b}}

The Correlation is in between
\deqn{\frac{-2}{n(n-1)} min(\frac{p}{1-p},\frac{1-p}{p}) \le correlation \le \frac{2p(1-p)}{(n-1)p(1-p)+0.25-fo} }
where \eqn{fo=min (x-(n-1)p-0.5)^2 }

The mean and the variance are denoted as
\deqn{E_{BetaCorrBin}[x]= np}
\deqn{Var_{BetaCorrBin}[x]= np(1-p)(n\Theta+1)(1+\Theta)^{-1}+n(n-1)cov}
\deqn{Corr_{BetaCorrBin}[x]=\frac{cov}{p(1-p)}}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col <- rainbow(5)
a <- c(9.0,10,11,12,13)
b <- c(8.0,8.1,8.2,8.3,8.4)
plot(0,0,main="Beta-Correlated binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,0.5))
for (i in 1:5)
{
lines(0:10,dBetaCorrBin(0:10,10,0.001,a[i],b[i])$pdf,col = col[i],lwd=2.85)
points(0:10,dBetaCorrBin(0:10,10,0.001,a[i],b[i])$pdf,col = col[i],pch=16)
}

dBetaCorrBin(0:10,10,0.001,10,13)$pdf      #extracting the pdf values
dBetaCorrBin(0:10,10,0.001,10,13)$mean     #extracting the mean
dBetaCorrBin(0:10,10,0.001,10,13)$var      #extracting the variance
dBetaCorrBin(0:10,10,0.001,10,13)$corr     #extracting the correlation
dBetaCorrBin(0:10,10,0.001,10,13)$mincorr  #extracting the minimum correlation value
dBetaCorrBin(0:10,10,0.001,10,13)$maxcorr  #extracting the maximum correlation value

#plotting the random variables and cumulative probability values
col <- rainbow(5)
a <- c(9.0,10,11,12,13)
b <- c(8.0,8.1,8.2,8.3,8.4)
plot(0,0,main="Beta-Correlated binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,1))
for (i in 1:5)
{
lines(0:10,pBetaCorrBin(0:10,10,0.001,a[i],b[i]),col = col[i],lwd=2.85)
points(0:10,pBetaCorrBin(0:10,10,0.001,a[i],b[i]),col = col[i],pch=16)
}

pBetaCorrBin(0:10,10,0.001,10,13)      #acquiring the cumulative probability values

}
\references{
Paul, S.R., 1985. A three-parameter generalization of the binomial distribution. Communications in Statistics
- Theory and Methods, 14(6), pp.1497-1506.

Available at: \url{http://www.tandfonline.com/doi/abs/10.1080/03610928508828990}.
}
