% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04a_ms_flat_1tail.R
\name{ms_flat_1tail}
\alias{ms_flat_1tail}
\title{Illustration of Model Selection Among 10 One Tail Distributions from the \code{fitdistcp} Package}
\usage{
ms_flat_1tail(x)
}
\arguments{
\item{x}{data vector}
}
\value{
Plots QQ plots to the screen, for each of the models,
and returns a data frame containing
\itemize{
\item MLE parameter values
\item AIC scores (times -0.5), AIC weights
\item WAIC1 scores, WAIC1 weights
\item WAIC2 scores, WAIC2 weights
\item logscores, logscore weights
\item maximum likelihood and calibrating prior means
\item maximum likelihood and calibrating prior standard deviations
}
}
\description{
Applies model selection using AIC, WAIC1, WAIC2 and leave-one-out logscore
to the input data \eqn{x},
for 10 one tailed models in the \code{fitdistcp} package
(although for the GPD, the logscore is NA for mathematical reasons).

The code is straightforward, and the point is to illustrate what is
possible using the model selection outputs from the \code{fitdistcp} routines.

The input data may be automatically shifted so that the minimum value is positive.

For the Pareto, the data may be further shifted so that the minimum value is slightly greater than 1.
}
\details{
The 10 models are:
\code{exp},
\code{pareto_k2},
\code{halfnorm},
\code{lnorm},
\code{frechet_k1},
\code{weibull},
\code{gamma},
\code{invgamma},
\code{invgauss} and
\code{gpd_k1}.
}
\examples{
\donttest{ # because it's too slow for CRAN
set.seed(1)
nx=50
x=rlnorm(nx)
print(ms_flat_1tail(x))
}


}
\author{
Stephen Jewson \email{stephen.jewson@gmail.com}
}
