% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitode-methods.R
\docType{methods}
\name{confint,fitode-method}
\alias{confint,fitode-method}
\title{Calculate confidence intervals from fitode objects for model parameters and their transformations}
\usage{
\S4method{confint}{fitode}(
  object,
  parm,
  level = 0.95,
  method = c("delta", "profile", "impsamp", "wmvrnorm"),
  nsim = 1000,
  seed,
  ...
)
}
\arguments{
\item{object}{fitode object}

\item{parm}{character vector specifying model parameters or list of formuals specifying transformations}

\item{level}{the confidence level required}

\item{method}{method for calculating confidence intervals}

\item{nsim}{number of simulations to be used for importance sampling}

\item{seed}{seed}

\item{...}{extra arguments passed to profiling method}
}
\value{
The confidence intervals for model parameters and their transformations of the fitode object
}
\description{
Calculate confidence intervals for model parameters and their transformations using
(1) delta method, (2) profile likelihood, and (3) importance sampling.
}
