% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotrate-class.R, R/spotratecurve-class.R
\name{as.spotrate}
\alias{as.spotrate}
\alias{as.spotrate,character-method}
\alias{as.spotrate,SpotRateCurve-method}
\title{Coerce to SpotRate}
\usage{
as.spotrate(x, ...)

\S4method{as.spotrate}{character}(x, simplify = TRUE)

\S4method{as.spotrate}{SpotRateCurve}(x, ...)
}
\arguments{
\item{x}{a character with SpotRate specification.}

\item{...}{additional arguments}

\item{simplify}{a boolean indicating whether to simplify SpotRate creation
or not. Defaults to TRUE.}
}
\value{
A \code{SpotRate} object created from a string.
}
\description{
Coerce character objects to SpotRate class
}
\details{
The character representation of a SpotRate is as follows:

\preformatted{"RATE COMPOUNDING DAYCOUNT CALENDAR"}

where:
\itemize{
\item \code{RATE} is a numeric value
\item \code{COMPOUNDING} is one of the following:
\code{simple}, \code{discrete}, \code{continuous}
\item \code{DAYCOUNT} is a valid day count rule, pex. \code{business/252},
see \linkS4class{Daycount}.
\item \code{CALENDAR} is the name of a bizdays calendar.
}

\code{simplify} check if compounding, daycount and calendar are the same for
all given characters.
If it is true the returned object is a SpotRate otherwise a \code{list} with
SpotRate objects is returned.
}
\examples{

as.spotrate(c(
  "0.06 simple actual/365 actual",
  "0.11 discrete business/252 actual"
))
}
