% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forwardrate-class.R
\name{forwardrate}
\alias{forwardrate}
\alias{forwardrate.numeric}
\alias{forwardrate.SpotRateCurve}
\title{Create a ForwardRate object}
\usage{
forwardrate(x, ...)

\method{forwardrate}{numeric}(x, terms, compounding, daycount, calendar, .copyfrom = NULL, ...)

\method{forwardrate}{SpotRateCurve}(x, t1 = NULL, t2 = NULL, ...)
}
\arguments{
\item{x}{a numeric or a SpotRateCurve object.}

\item{...}{additional arguments.}

\item{terms}{a numeric vector with positive values representing terms of
the forward rates.}

\item{compounding}{a character with the compouning name.}

\item{daycount}{a character representing the daycount.}

\item{calendar}{a calendar object.}

\item{.copyfrom}{a SpotRate object that is used as reference to build
the SpotRateCurve object.}

\item{t1}{initial term}

\item{t2}{final term}
}
\value{
A \code{ForwardRate} object.

The arguments \code{t1} and \code{t2} define initial and final term used to
extract a ForwardRate from a SpotRateCurve.
}
\description{
\code{forwardrate()} creates a ForwardRate object.
}
