% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{estfun.fixest}
\alias{estfun.fixest}
\title{Extracts the scores from a fixest estimation}
\usage{
\method{estfun}{fixest}(x, ...)
}
\arguments{
\item{x}{A \code{fixest} object, obtained for instance from \code{\link{feols}}.}

\item{...}{Not currently used.}
}
\value{
Returns a matrix of the same number of rows as the number of observations used for the estimation, and the same number of columns as there were variables.
}
\description{
Extracts the scores from a fixest estimation.
}
\examples{

data(iris)
est = feols(Petal.Length ~ Petal.Width + Sepal.Width, iris)
head(estfun(est))

}
