% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{rep.fixest}
\alias{rep.fixest}
\alias{rep.fixest_list}
\alias{.l}
\title{Replicates \code{fixest} objects}
\usage{
\method{rep}{fixest}(x, times = 1, each = 1, vcov, ...)

\method{rep}{fixest_list}(x, times = 1, each = 1, vcov, ...)

.l(...)
}
\arguments{
\item{x}{Either a \code{fixest} object, either a list of \code{fixest} objects created with \code{.l()}.}

\item{times}{Integer vector giving the number of repetitions of the vector of elements. By default \code{times = 1}. It must be either of length 1, either of the same length as the argument \code{x}.}

\item{each}{Integer scalar indicating the repetition of each element. Default is 1.}

\item{vcov}{A list containing the types of standard-error to be computed, default is missing. If not missing, it must be of the same length as \code{times}, \code{each}, or the final vector. Note that if the arguments \code{times} and \code{each} are missing, then \code{times} becomes equal to the length of \code{vcov}. To see how to summon a VCOV, see the dedicated section in the \href{https://lrberge.github.io/fixest/articles/fixest_walkthrough.html#the-vcov-argument-1}{vignette}.}

\item{...}{In \code{.l()}: \code{fixest} objects. In \code{rep()}: not currently used.}
}
\value{
Returns a list of the appropriate length. Each element of the list is a \code{fixest} object.
}
\description{
Simple function that replicates \code{fixest} objects while (optionally) computing different standard-errors. Useful mostly in combination with \code{\link{etable}} or \code{\link{coefplot}}.
}
\details{
To apply \code{rep.fixest} on a list of \code{fixest} objects, it is absolutely necessary to use \code{.l()} and not \code{list()}.
}
\examples{

# Let's show results with different standard-errors

est = feols(Ozone ~ Solar.R + Wind + Temp, data = airquality)

my_vcov = list(~ Month, ~ Day, ~ Day + Month)

etable(rep(est, vcov = my_vcov))

coefplot(rep(est, vcov = my_vcov), drop = "Int")

#
# To rep multiple objects, you need to use .l()
#

est_bis = feols(Ozone ~ Solar.R + Wind + Temp | Month, airquality)

etable(rep(.l(est, est_bis), vcov = my_vcov))

# using each
etable(rep(.l(est, est_bis), each = 3, vcov = my_vcov))


}
