% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deprecated_funs.R
\name{did_plot_yearly_effects}
\alias{did_plot_yearly_effects}
\title{Plots the results of yearly treatment effects estimation}
\usage{
did_plot_yearly_effects(
  object,
  x.shift = 0,
  w = 0.1,
  ci_level = 0.95,
  style = c("bar", "interval", "tube"),
  add = FALSE,
  col = 1,
  bar.col = col,
  bar.lwd = par("lwd"),
  bar.lty,
  grid = TRUE,
  grid.par = list(lty = 1),
  bar.join = TRUE,
  ...
)
}
\arguments{
\item{object}{An object returned by the function \code{\link[fixest]{did_estimate_yearly_effects}}.}

\item{x.shift}{Shifts the confidence intervals bars to the left or right, depending on the value of \code{x.shift}. Default is 0.}

\item{w}{The width of the confidence intervals.}

\item{ci_level}{Scalar between 0 and 1: the level of the CI. By default it is equal to 0.95.}

\item{style}{One of \code{"bar"} (default), \code{"interval"} or \code{"tube"}. The style of the plot.}

\item{add}{Default is \code{FALSE}, if the intervals are to be added to an existing graph. Note that if it is the case, then the argument \code{x} MUST be numeric.}

\item{col}{Color of the point estimate and of the line joining them (if \code{style = "interval"}).}

\item{bar.col}{Color of the bars of the confidence interval. Defaults to \code{col}.}

\item{bar.lwd}{Line width of the confidence intervals, defaults to \code{1}.}

\item{bar.lty}{Line type of the confidence intervals, defaults to \code{1} for \code{style = "bar"} and to \code{2} for \code{style = "interval"}.}

\item{grid}{Whether to add an horizontal grid. Default is \code{TRUE}.}

\item{grid.par}{Graphical parameters used when plotting the grid in the background. Default is \code{list(lty=1)}.}

\item{bar.join}{Logical, default is \code{FALSE}. Whether to join the dots when \code{style = "bar"}.}

\item{...}{Any other argument to be passed to \code{summary} or to \code{plot}.}
}
\description{
This function plots the results of a \code{\link[fixest]{did_estimate_yearly_effects}} estimation.
}
\examples{

# Sample data illustrating the DiD
data(base_did)

# Estimation of yearly effect (they are automatically added)
est = did_estimate_yearly_effects(y ~ x1 + treat + post, base_did,
                                  treat_time = ~treat+period, reference = 5)

# Now we plot the results
did_plot_yearly_effects(est)

# Now with fixed-effects:
est_fe = did_estimate_yearly_effects(y ~ x1 | id + period, base_did,
                                     treat_time = ~treat+period, reference = 5)
did_plot_yearly_effects(est_fe)

# you can change the type of SE to be plotted:
did_plot_yearly_effects(est_fe, se = "cluster") # default
did_plot_yearly_effects(est_fe, se = "standard")


}
\seealso{
\code{\link{fixest-deprecated}}
}
\author{
Laurent Berge
}
\keyword{internal}
