% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etable.R
\name{etable}
\alias{etable}
\alias{esttex}
\alias{esttable}
\alias{setFixest_etable}
\alias{getFixest_etable}
\title{Estimations table (export the results of multiples estimations to a DF or to Latex)}
\usage{
etable(
  ...,
  se = c("standard", "white", "cluster", "twoway", "threeway", "fourway"),
  dof = getFixest_dof(),
  cluster,
  digits = 4,
  tex,
  fitstat,
  title,
  coefstat = c("se", "tstat", "confint"),
  ci = 0.95,
  sdBelow = TRUE,
  keep,
  drop,
  order,
  dict,
  file,
  replace = FALSE,
  convergence,
  signifCode,
  label,
  float,
  subtitles,
  fixef_sizes = FALSE,
  fixef_sizes.simplify = TRUE,
  yesNo = "Yes",
  keepFactors = TRUE,
  family,
  powerBelow = -5,
  interaction.combine = " $\\\\times $ ",
  depvar,
  style = list(),
  notes = NULL,
  group = NULL,
  extraline = NULL,
  tablefoot = TRUE
)

esttex(
  ...,
  se = c("standard", "white", "cluster", "twoway", "threeway", "fourway"),
  dof = getFixest_dof(),
  cluster,
  digits = 4,
  fitstat,
  coefstat = c("se", "tstat", "confint"),
  ci = 0.95,
  title,
  float = float,
  sdBelow = TRUE,
  keep,
  drop,
  order,
  dict,
  file,
  replace = FALSE,
  convergence,
  signifCode = c(`***` = 0.01, `**` = 0.05, `*` = 0.1),
  label,
  subtitles,
  fixef_sizes = FALSE,
  fixef_sizes.simplify = TRUE,
  yesNo = "Yes",
  keepFactors = TRUE,
  family,
  powerBelow = -5,
  interaction.combine = " $\\\\times $ ",
  style = list(),
  notes = NULL,
  group = NULL,
  tablefoot = TRUE,
  extraline = NULL
)

esttable(
  ...,
  se = c("standard", "white", "cluster", "twoway", "threeway", "fourway"),
  dof = getFixest_dof(),
  cluster,
  coefstat = c("se", "tstat", "confint"),
  ci = 0.95,
  depvar,
  keep,
  drop,
  dict,
  order,
  digits = 4,
  fitstat,
  convergence,
  signifCode = c(`***` = 0.001, `**` = 0.01, `*` = 0.05, . = 0.1),
  subtitles,
  keepFactors = FALSE,
  family,
  group = NULL,
  extraline = NULL
)

setFixest_etable(
  digits = 4,
  fitstat,
  coefstat = c("se", "tstat", "confint"),
  ci = 0.95,
  sdBelow = TRUE,
  keep,
  drop,
  order,
  dict,
  signifCode,
  float,
  fixef_sizes = FALSE,
  fixef_sizes.simplify = TRUE,
  yesNo = c("Yes", "No"),
  family,
  powerBelow = -5,
  interaction.combine = " $\\\\times $ ",
  depvar,
  style = list(),
  notes = NULL,
  group = NULL,
  extraline = NULL,
  tablefoot = TRUE,
  reset = FALSE
)

getFixest_etable()
}
\arguments{
\item{...}{Used to capture different \code{fixest} estimation objects (obtained with \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}). Note that any other type of element is discarded. Note that you can give a list of \code{fixest} objects.}

\item{se}{Character scalar. Which kind of standard error should be computed: \dQuote{standard}, \dQuote{White}, \dQuote{cluster}, \dQuote{twoway}, \dQuote{threeway} or \dQuote{fourway}? By default if there are clusters in the estimation: \code{se = "cluster"}, otherwise \code{se = "standard"}. Note that this argument can be implicitly deduced from the argument \code{cluster}.}

\item{dof}{An object of class \code{dof.type} obtained with the function \code{\link[fixest]{dof}}. Represents how the degree of freedom correction should be done.You must use the function \code{\link[fixest]{dof}} for this argument. The arguments and defaults of the function \code{\link[fixest]{dof}} are: \code{adj = TRUE}, \code{fixef.K="nested"}, \code{cluster.adj = TRUE}, \code{cluster.df = "conventional"}, \code{t.df = "conventional"}, \code{fixef.force_exact=FALSE)}. See the help of the function \code{\link[fixest]{dof}} for details.}

\item{cluster}{Tells how to cluster the standard-errors (if clustering is requested). Can be either a list of vectors, a character vector of variable names, a formula or an integer vector. Assume we want to perform 2-way clustering over \code{var1} and \code{var2} contained in the data.frame \code{base} used for the estimation. All the following \code{cluster} arguments are valid and do the same thing: \code{cluster = base[, c("var1, "var2")]}, \code{cluster = c("var1, "var2")}, \code{cluster = ~var1+var2}. If the two variables were used as clusters in the estimation, you could further use \code{cluster = 1:2} or leave it blank with \code{se = "twoway"} (assuming \code{var1} [resp. \code{var2}] was the 1st [res. 2nd] cluster).}

\item{digits}{Integer, default is 4. The number of digits to be displayed.}

\item{tex}{Logical: whether the results should be a data.frame or a Latex table. By default, this argument is \code{TRUE} if the argument \code{file} (used for exportation) is not missing; it is equal to \code{FALSE} otherwise.}

\item{fitstat}{A character vector or a one sided formula. A vector listing which fit statistics to display. The valid types are 'll', 'aic', 'bic' and r2 types like 'r2', 'pr2', 'war2', etc (see all valid types in \code{\link[fixest]{r2}}). The default value depends on the models to display. Example of use: \code{fitstat=c('sq.cor', 'ar2', 'war2')}, or \code{fitstat=~sq.cor+ar2+war2} using a formula.}

\item{title}{(Tex only.) Character scalar. The title of the Latex table.}

\item{coefstat}{One of \code{"se"} (default), \code{"tstat"} or \code{"confint"}. The statistic to report for each coefficient: the standard-error, the t-statistics or the confidence interval. You can adjust the confidence interval with the argument \code{ci}.}

\item{ci}{Level of the confidence interval, defaults to \code{0.95}. Only used if \code{coefstat = confint}.}

\item{sdBelow}{(Tex only.) Logical, default is \code{TRUE}. Should the standard-errors be displayed below the coefficients?}

\item{keep}{Character vector. This element is used to display only a subset of variables. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). Each variable satisfying any of the regular expressions will be kept. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \code{keep = "x[[:digit:]]$"}. If the first character is an exclamation mark, the effect is reversed (e.g. keep = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is kept). See details.}

\item{drop}{Character vector. This element is used if some variables are not to be displayed. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). Each variable satisfying any of the regular expressions will be discarded. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \code{drop = "x[[:digit:]]{2}"}. If the first character is an exclamation mark, the effect is reversed (e.g. drop = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is dropped). See details.}

\item{order}{Character vector. This element is used if the user wants the variables to be ordered in a certain way. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). The variables satisfying the first regular expression will be placed first, then the order follows the sequence of regular expressions. This argument is applied post aliasing (see argument \code{dict}). Example: you have the following variables: \code{month1} to \code{month6}, then \code{x1} to \code{x5}, then \code{year1} to \code{year6}. If you want to display first the x's, then the years, then the months you could use: \code{order = c("x", "year")}. If the first character is an exclamation mark, the effect is reversed (e.g. order = "!Intercept" means: every variable that does not contain \dQuote{Intercept} goes first).  See details.}

\item{dict}{A named character vector or a logical scalar. It changes the original variable names to the ones contained in the \code{dict}ionary. E.g. to change the variables named \code{a} and \code{b3} to (resp.) \dQuote{$log(a)$} and to \dQuote{$bonus^3$}, use \code{dict=c(a="$log(a)$",b3="$bonus^3$")}. By default, if Tex output is requested or if argument \code{file} is not missing, it is equal to \code{getFixest_dict()}, a default dictionary which can be set with \code{\link[fixest]{setFixest_dict}}. The default is not to change names if a \code{data.frame} is requested (i.e. \code{tex = FALSE}); if so, you can use \code{dict = TRUE} to use the dictionary you've set globally with \code{setFixest_dict()}.}

\item{file}{A character scalar. If provided, the Latex (or data frame) table will be saved in a file whose path is \code{file}. If you provide this argument, then a Latex table will be exported, to export a regular \code{data.frame}, use argument \code{tex = FALSE}.}

\item{replace}{Logical, default is \code{FALSE}. Only used if option \code{file} is used. Should the exported table be written in a new file that replaces any existing file?}

\item{convergence}{Logical, default is missing. Should the convergence state of the algorithm be displayed? By default, convergence information is displayed if at least one model did not converge.}

\item{signifCode}{Named numeric vector, used to provide the significance codes with respect to the p-value of the coefficients. Default is \code{c("***"=0.01, "**"=0.05, "*"=0.10)} for a Latex table and \code{c("***"=0.001, "**"=0.01, "*"=0.05, "."=0.10)} for a data.frame (to conform with R's default). To supress the significance codes, use \code{signifCode=NA} or \code{signifCode=NULL}. Can also be equal to \code{"letters"}, then the default becomes \code{c("a"=0.01, "b"=0.05, "c"=0.10)}.}

\item{label}{(Tex only.) Character scalar. The label of the Latex table.}

\item{float}{(Tex only.) Logical. By default, if the argument \code{title} or \code{label} is provided, it is set to \code{TRUE}. Otherwise, it is set to \code{FALSE}.}

\item{subtitles}{Character vector of the same length as the number of models to be displayed. If provided, subtitles are added underneath the dependent variable name.}

\item{fixef_sizes}{(Tex only.) Logical, default is \code{FALSE}. If \code{TRUE} and fixed-effects were used in the models, then the number of "individuals" per fixed-effect dimension is also displayed.}

\item{fixef_sizes.simplify}{Logical, default is \code{TRUE}. Only used if \code{fixef_sizes = TRUE}. If \code{TRUE}, the fixed-effects sizes will be displayed in parentheses instead of in a separate line if there is no ambiguity (i.e. if the size is constant across models).}

\item{yesNo}{(Tex only.) A character vector of length 1 or 2. Default is \code{c("Yes", "No")}. This is the message displayed when a given fixed-effect is (or is not) included in a regression. If \code{yesNo} is of length 1, then the second element is the empty string.}

\item{keepFactors}{Logical, default is \code{TRUE}. If \code{FALSE}, then factor variables are displayed as fixed-effects and no coefficient is shown.}

\item{family}{Logical, default is missing. Whether to display the families of the models. By default this line is displayed when at least two models are from different families.}

\item{powerBelow}{(Tex only.) Integer, default is -5. A coefficient whose value is below \code{10**(powerBelow+1)} is written with a power in Latex. For example \code{0.0000456} would be written \code{4.56$\\times 10^{-5}$} by default. Setting \code{powerBelow = -6} would lead to \code{0.00004} in Latex.}

\item{interaction.combine}{(Tex only.) Character scalar, defaults to \code{" $\\times$ "}. When the estimation contains interactions, then the variables names (after aliasing) are combined with this argument. For example: if \code{dict = c(x1="Wind", x2="Rain")} and you have the following interaction \code{x1:x2}, then it will be renamed (by default) \code{Wind $\\times$ Rain} -- using \code{interaction.combine = "*"} would lead to \code{Wind*Rain}.}

\item{depvar}{(Data frame only.) Logical, default is missing. Whether a first line containing the dependent variables should be shown. By default, the dependent variables are shown only if they differ across models or if the argumen \code{file} is not missing.}

\item{style}{A list. You can change the general style of the table with this argument. It should be of the form \code{style = list(keyword="key1:value1;key2:value2")} etc. The available keywords are \code{lines} (to manage the type of lines appearing in the table), and \code{depvar}, \code{model}, \code{var}, \code{fixef}, \code{slopes}, \code{fixef.sizes}, \code{stats} and \code{notes}. Most of these keywords accept the key \code{title:} which affects the title appearing just before the section. Eg to drop the \emph{Variables} header, just use \code{style=list("title:")}. Note that if you use \code{style=list("title: ")} (note the space after ":"), then an empty line will still be there. The keywords fixef, slopes and fixef.sizes also accept the keys \code{prefix} and \code{suffix}. E.g. if \code{style=list(fixef="suffix: FE")}, then there will be no header showing but the text " FE" will be appended to the ficed-effects variable names. The keys accepted in \code{lines} are \code{top}, \code{bottom}, \code{foot} and \code{sep}.}

\item{notes}{Character vector. If provided, a \code{"notes"} section will be added at the end right after the end of the table, containing the text of this argument. Note that if it is a vector, it will be collapsed with new lines.}

\item{group}{A list. The list elements should be vectors of regular expressions. For each elements of this list: A new line in the table is created, all variables that are matched by the regular expressions are discarded (same effect as the argument \code{drop}) and \code{TRUE} or \code{FALSE} will appear in the model cell, depending on whether some of the previous variables were found in the model. Example: \code{group=list("Controls: personal traits"=c("gender", "height", "weight"))} will create an new line with \code{"Controls: personal traits"} in the leftmost cell, all three variables gender, height and weight are discared, TRUE appearing in each model containing at least one of the three variables (the style of TRUE/FALSE is governed by the argument \code{yesNo}). You can control the style with the \code{title} and \code{where} keywords in curly brackets. For example \code{group=list("{title:Controls; where:stats}Personal traits"=c("gender", "height", "weight"))} will add an extra line right before with "Control" written in it, and the group information will appear after the statistics. The keyword where can be equal to either \code{var} (default), \code{fixef} or \code{stats}.}

\item{extraline}{A list. The list elements should be either a single logical or a vector of the same length as the number of models. For each elements of this list: A new line in the table is created, the list name being the row name and the vector being the content of the cells. Example: \code{extraline=list("Sub-sample"=c("<20 yo", "all", ">50 yo"))} will create an new line with \code{"Sub-sample"} in the leftmost cell, the vector filling the content of the cells for the three models. You can control the style with the \code{title} and \code{where} keywords in curly brackets. For example \code{group=list("{title:Sub-sample; where:stats}By age"=c("<20 yo", "all", ">50 yo"))} will add an extra line right before with "Sub-sample" written in it, and the extraline information will appear after the statistics section. The keyword where can be equal to either \code{var} (default), \code{fixef} or \code{stats}.}

\item{tablefoot}{Logical, default is \code{TRUE}. Whether to display the table footer containing the information on the way the standard-errors where computed and the meaning of the significance codes.}

\item{reset}{(\code{setFixest_etable} only.) Logical, default is \code{FALSE}. If \code{TRUE}, this will reset all the default values that were already set by the user in previous calls.}
}
\value{
If \code{tex = TRUE}, the lines composing the Latex table are returned invisibly while the table is directly prompted on the console.

If \code{tex = FALSE}, the data.frame is directly returned. If the argument \code{file} is not missing, the \code{data.frame} is returned invisibly.
}
\description{
Aggregates the results of multiple estimations and displays them in the form of either a Latex table or a \code{data.frame}.
}
\details{
The function \code{esttex} is equivalent to the function \code{etable} with argument \code{tex = TRUE}.

The function \code{esttable} is equivalent to the function \code{etable} with argument \code{tex = FALSE}.

You can permanently change the way your table looks in Latex by using \code{setFixest_etable}. The following vignette gives and example as well as illustrates how to use the argument \code{style}: \href{https://cran.r-project.org/package=fixest/vignettes/exporting_tables.html}{Exporting estimation tables}.
}
\section{Functions}{
\itemize{
\item \code{esttex}: Exports the results of multiple \code{fixest} estimations in a Latex table.

\item \code{esttable}: Facility to display the results of multiple \code{fixest} estimations.
}}

\section{Arguments keep, drop and order}{

The arguments \code{keep}, \code{drop} and \code{order} use regular expressions. If you are not aware of regular expressions, I urge you to learn it, since it is an extremely powerful way to manipulate character strings (and it exists across most programming languages).

For example drop = "Wind" would drop any variable whose name contains "Wind". Note that variables such as "Temp:Wind" or "StrongWind" do contain "Wind", so would be dropped. To drop only the variable named "Wind", you need to use \code{drop = "^Wind$"} (with "^" meaning beginning, resp. "$" meaning end, of the string => this is the language of regular expressions).

Although you can combine several regular expressions in a single character string using pipes, \code{drop} also accepts a vector of regular expressions.

You can use the special character "!" (exclamation mark) to reverse the effect of the regular expression (this feature is specific to this fonction). For example \code{drop = "!Wind"} would drop any variable that does not contain "Wind".

You can use the special character "%" (percentage) to make reference to the original variable name instead of the aliased name. For example, you have a variable named \code{"Month6"}, and use a dictionary \code{dict = c(Month6="June")}. Thus the variable will be displayed as \code{"June"}. If you want to delete that variable, you can use either \code{drop="June"}, or \code{drop="%Month6"} (which makes reference to its original name).

The argument \code{order} takes in a vector of regular expressions, the order will follow the elments of this vector. The vector gives a list of priorities, on the left the elements with highest priority. For example, order = c("Wind", "!Inter", "!Temp") would give highest priorities to the variables containing "Wind" (which would then appear first), second highest priority is the variables not containing "Inter", last, with lowest priority, the variables not containing "Temp". If you had the following variables: (Intercept), Temp:Wind, Wind, Temp you would end up with the following order: Wind, Temp:Wind, Temp, (Intercept).
}

\examples{

aq = airquality
aq$Month = factor(aq$Month)

est1 = feols(Ozone ~ Month / Wind + Temp, data = aq)
est2 = feols(Ozone ~ Wind + Temp | Month, data = aq)

# Displaying the two results in a single table
etable(est1, est2)

# keep/drop: keeping only interactions
etable(est1, est2, keep = ":")
# or using drop  (see regexp help):
etable(est1, est2, drop = "^[[:alnum:]]+$")

# keep/drop: dropping interactions
etable(est1, est2, drop = ":")
# or using keep ("!" reverses the effect):
etable(est1, est2, keep = "!:")

# order: Wind variable first, intercept last
etable(est1, est2, order = c("Wind", "Month"))
etable(est1, est2, order = c("^Wind", "Wind", "Month"))
# Interactions, then Intercept, last ("!" reverses the effect)
etable(est1, est2, order = c("!Int", "!:"))

# dict + keep/drop/order: using "\%" to match the original names
dict = c("Month5"="May", "Month6"="Jun", "Month7"="Jul",
         "Month8"="Aug", "Month9"="Sep")
etable(est1, est2, tex = TRUE, dict = dict)
# keeping only June and July
etable(est1, est2, tex = TRUE, dict = dict, keep = c("\%Month6", "Jul"))
# All months variabes first
etable(est1, est2, tex = TRUE, dict = dict, order = c("\%Month"))

# signifCode
etable(est1, est2, signifCode = c(" A"=0.01, " B"=0.05, " C"=0.1,
                                  " D"=0.15, " F"=1))

# fitstat
etable(est1, est2, fitstat = ~r2+ar2+apr2+war2)

# Adding a dictionnary (Tex only)
dict = c(Month5="May", Month6="Jun", Month7="Jul", Month8="Aug", Month9="Sep")
etable(est1, est2, dict = dict, tex = TRUE)

#
# Using the argument style to customize Latex exports
#

# If you don't like the default layout of the table, no worries!
# You can modify many parameters with the argument style

# To drop the headers before each section, use:
style_noHeaders = list(var="", fixef="suffix: FE", stats = "")
etable(est1, est2, dict = dict, tex = TRUE, style = style_noHeaders)

# To change the lines of the table
style_lines = list(lines = "top:\\\\toprule;bottom:\\\\bottomrule;sep:\\\\midrule;foot:\\\\midrule")
etable(est1, est2, dict = dict, tex = TRUE, style = style_lines)

#
# Group and extraline
#

# Sometimes it's useful to group control variables into a single line
# You can achieve that with the group argument

setFixest_fml(..ctrl = ~ poly(Wind, 2) + poly(Temp, 2))
est_c0 = feols(Ozone ~ Solar.R, data = aq)
est_c1 = feols(Ozone ~ Solar.R + ..ctrl, data = aq)
est_c2 = feols(Ozone ~ Solar.R + I(Solar.R**2) + ..ctrl, data = aq)

etable(est_c0, est_c1, est_c2, group = list(Controls = "poly"))

# 'group' here does the same as drop = "poly", but adds an extra line
# with TRUE/FALSE where the variables were found

# 'extraline' adds an extra line, where you can add the value for each model
est_all  = feols(Ozone ~ Solar.R + Temp + Wind, data = aq)
est_sub1 = feols(Ozone ~ Solar.R + Temp + Wind, data = aq[aq$Month \%in\% 5:6, ])
est_sub2 = feols(Ozone ~ Solar.R + Temp + Wind, data = aq[aq$Month \%in\% 7:8, ])
est_sub3 = feols(Ozone ~ Solar.R + Temp + Wind, data = aq[aq$Month == 9, ])

etable(est_all, est_sub1, est_sub2, est_sub3,
       extraline = list("Sub-sample" = c("All", "May-June", "Jul.-Aug.", "Sept.")))

# When exporting to Latex, you can add meta arguments to 'group' and 'extraline'
# Two keywords are allowed: 'title' and 'where'
# 'title' adds a line just before with the content of 'title' in the leftmost cell
# 'where' governs the location of the line. It can be equal to 'var', 'stats' or 'fixef'.
# The syntax is: {title:Controls; where:stats}Group name.
# Note that starting with curly braces is mandatory.

# Examples
etable(est_c0, est_c1, est_c2, tex = TRUE, group = list("{where:stats}Controls" = "poly"))
etable(est_all, est_sub1, est_sub2, est_sub3, tex = TRUE,
       extraline = list("{title:\\\\midrule}Sub-sample" =
                          c("All", "May-June", "Jul.-Aug.", "Sept.")))

}
\seealso{
See also the main estimation functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}. Use \code{\link[fixest]{summary.fixest}} to see the results with the appropriate standard-errors, \code{\link[fixest]{fixef.fixest}} to extract the fixed-effects coefficients.
}
\author{
Laurent Berge
}
