% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{BIC.fixest}
\alias{BIC.fixest}
\title{Bayesian information criterion}
\usage{
\method{BIC}{fixest}(object, ...)
}
\arguments{
\item{object}{A \code{fixest} object. Obtained using the functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}.}

\item{...}{Optionally, more fitted objects.}
}
\value{
It return a numeric vector, with length the same as the number of objects taken as arguments.
}
\description{
This function computes the BIC (Bayesian information criterion) from a \code{fixest} estimation.
}
\details{
The BIC is computed as follows:
\deqn{BIC = -2\times LogLikelihood + \log(nobs)\times nbParams}
with k the penalty parameter.

You can have more information on this criterion on \code{\link[stats]{AIC}}.
}
\examples{

# two fitted models with different expl. variables:
res1 = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
            Petal.Width | Species, iris)
res2 = femlm(Sepal.Length ~ Petal.Width | Species, iris)

AIC(res1, res2)
BIC(res1, res2)

}
\seealso{
See also the main estimation functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}. Other statistics functions: \code{\link[fixest]{AIC.fixest}}, \code{\link[fixest]{logLik.fixest}}.
}
\author{
Laurent Berge
}
