% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm_computeGridCenters.R
\name{computeGridCenters}
\alias{computeGridCenters}
\title{Compute the Cell Centers of a Cell Mapping Grid}
\usage{
computeGridCenters(lower, upper, blocks)
}
\arguments{
\item{lower}{[\code{\link{numeric}} or \code{\link{integer}}]\cr
The lower limits per dimension.}

\item{upper}{[\code{\link{numeric}} or \code{\link{integer}}]\cr
The upper limits per dimension.}

\item{blocks}{[\code{\link{integer}}]\cr
The number of blocks per dimension.}
}
\value{
[\code{\link{data.frame}}].\cr
  A \code{data.frame}, which includes the coordinates of the cell centers,
  as well as the corresponding cell ID (\code{cell.ID}).
}
\description{
Computes the cell centers and the corresponding cell IDs of a cell mapping
  grid.
}
\examples{
computeGridCenters(lower = -10, upper = 10, blocks = c(10, 5, 8))

}

