% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_counts.R
\name{grouped_counts}
\alias{grouped_counts}
\title{Grouped count}
\usage{
grouped_counts(data, by = NULL, w = NULL, value_name = "n", ...)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{by}{An optional vector of column names in \code{data} used to group the results.}

\item{w}{Optional name of the column in \code{data} with case weights.}

\item{value_name}{Name of the resulting column with counts.}

\item{...}{Arguments passed to \code{sum} (only if weights are provided).}
}
\value{
A \code{data.frame} with columns \code{by} and \code{value_name}.
}
\description{
Calculates weighted counts grouped by optional columns.
}
\examples{
grouped_counts(iris)
grouped_counts(iris, by = "Species")
grouped_counts(iris, w = "Petal.Length")
grouped_counts(iris, by = "Species", w = "Petal.Length")
}
