% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trie.R
\name{Trie}
\alias{Trie}
\title{Trie}
\description{
Trie

Trie
}
\details{
Trie is used to store the lexicon in language model. We use it to limit
the search space in decoder and quickly look up scores for a given token
(completed word) or make prediction for incompleted ones based on smearing.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{rootIdx}}{the rootIdx.}

\item{\code{maxChildren}}{The maximum number of children for each node. It is
usually the size of letters or phonemes.}

\item{\code{ptr}}{set and get the pointer to a Trie instance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Trie-new}{\code{Trie$new()}}
\item \href{#method-Trie-get_root}{\code{Trie$get_root()}}
\item \href{#method-Trie-insert}{\code{Trie$insert()}}
\item \href{#method-Trie-search}{\code{Trie$search()}}
\item \href{#method-Trie-smear}{\code{Trie$smear()}}
\item \href{#method-Trie-clone}{\code{Trie$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trie-new"></a>}}
\if{latex}{\out{\hypertarget{method-Trie-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trie$new(maxChildren = NULL, rootIdx = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{maxChildren}}{a maxChildren}

\item{\code{rootIdx}}{a rootIdx}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Trie
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trie-get_root"></a>}}
\if{latex}{\out{\hypertarget{method-Trie-get_root}{}}}
\subsection{Method \code{get_root()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trie$get_root()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the root node pointer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trie-insert"></a>}}
\if{latex}{\out{\hypertarget{method-Trie-insert}{}}}
\subsection{Method \code{insert()}}{
Insert a token into trie with label
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trie$insert(indices, label, score)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indices}}{a indices}

\item{\code{label}}{a label}

\item{\code{score}}{a score}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a TrieNodePtr
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trie-search"></a>}}
\if{latex}{\out{\hypertarget{method-Trie-search}{}}}
\subsection{Method \code{search()}}{
Get the labels for a given token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trie$search(indices)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indices}}{a indices}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a TrieNodePtr
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trie-smear"></a>}}
\if{latex}{\out{\hypertarget{method-Trie-smear}{}}}
\subsection{Method \code{smear()}}{
Smearing the trie using the valid labels inserted in the trie 
so as to get score on each node (incompleted token).
For example, if smear_mode is MAX, then for node "a" in path "c"->"a", we
will select the maximum score from all its children like "c"->"a"->"t",
"c"->"a"->"n", "c"->"a"->"r"->"e" and so on.
This process will be carry out recursively on all the nodes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trie$smear(smearMode)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{smearMode}}{a smearMode (see [SmearingModes] for options)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible(NULL)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trie-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Trie-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trie$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
