% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkhist.R
\name{rkhist}
\alias{rkhist}
\title{Return the rank histogram of an observation in an ensemble
forecast}
\usage{
rkhist(fcst, obs, ...)
}
\arguments{
\item{fcst}{an object containing the ensemble forecasts.}

\item{obs}{an object containing the observation associated to the forecast in
\code{fcst}.}

\item{...}{additional arguments.}
}
\value{
An S3 object of class \code{rkhist} (indeed a matrix containing the
count for each rank, with \code{class} "rkhist"). Each row of the matrix
contains the counts for one rank histogram.
}
\description{
This S3 generic function is intended to compute the rank of each observation
when pooled with its associated ensemble forecast and return the count in
each rank (i.e. the rank histogram).
}
\details{
For new methods, the output should be an object of class
\code{c("rkhist", "matrix")}, with one rank histogram in each row. Rows may
be named.
}
\examples{
set.seed(42)
N <- 1000
M <- 20
fcst <- matrix(rnorm(N*M), ncol = M)
fcst2 <- matrix(rnorm(N*M), ncol = M)
obs <- rnorm(N)
## Computation of one rank histogram
# Named
rkh <- rkhist(fcst, obs, names = "a")
print(rkh)
plot(rkh)
# Unnamed
rkh2 <- rkhist(fcst2, obs)
print(rkh2)
plot(rkh2)

## Computation of two rank histograms, from a list of forecasts, with the
## same observation vector
fcstsl <- list(fcst, fcst2)
rkhsl <- rkhist(fcstsl, obs, names = c("a", NA))
print(rkhsl)
plot(rkhsl)

## Concatenation of two rank histograms, with different names
rkhs <- rbind_rkhists(rkh, rkh2, names = letters[3:4])
rownames(rkhs)
print(rkhs)
plot(rkhs)
}
