% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{remove_k}
\alias{remove_k}
\alias{remove_k.pivot_table}
\title{Remove thousands separator}
\usage{
remove_k(pt, sep)

\method{remove_k}{pivot_table}(pt, sep = ".")
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{sep}{A character, thousands separator to remove.}
}
\value{
A \code{pivot_table} object.
}
\description{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data. Values, even though they are numbers, are
represented as text and sometimes include a thousands separator that can be
removed using this function.
}
\details{
To correctly carry out this operation, the number of rows and columns that
contain labels must be defined, and the table must only contain the pivot
table rows and columns.
}
\examples{

pt <-
  pt_ex |>
  remove_top(1) |>
  define_labels(n_col = 2, n_row = 2) |>
  remove_k()

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
