<!-- Generated by galley: do not edit by hand -->

``` r
library(fledge)
```

The goal of {fledge} is to streamline the process of versioning R
packages and updating the `NEWS.md` file. It applies to R packages that
are being version controlled on GitHub. By incorporating a few simple
and easy steps during the development process, you can ensure that
versioning and updating of `NEWS.md` and `DESCRIPTION` is easily
achieved for release.

## Installation

The package can be installed from GitHub using the command

``` r
devtools::install_github("cynkra/fledge")
```

## Why use fledge?

Without {fledge}, you probably follow these steps at different stages of
your workflow.

1.  Check the previous version used, before assigning a new version
    number.
2.  Manually update `NEWS.md` with each substantial change, and/or check
    the previous commit messages to decide what should go in the
    `NEWS.md` file.
3.  Manually merge the `NEWS.md` files from different branches after
    reviewing the discrepancies.

{fledge} provides standardised version number updates to your package.
It can also read your commit messages from recent commits and include
the marked lines in `NEWS.md`. As the `NEWS.md` is generated by
{fledge}, there is no need to merge it manually. All of this can be
achieved with just one function call.

Using {fledge} would not only save you time, but will also streamline
the process of versioning and updating `NEWS.md`.

## Functions

{fledge} consists of the following functions that enable versioning at
different stages through the package development lifecycle.

| Function Name         | Description                                                                                          | Stage Applicable                    |
|-----------------------|------------------------------------------------------------------------------------------------------|-------------------------------------|
| `bump_version(which)` | Increments the package version based on argument. (Version format supported *major.minor.dev.patch*) | Configuration, Development, Release |
| `finalize_version()`  | Finalize the package version                                                                         | Configuration, Development          |
| `commit_version()`    | Commits `NEWS.md` and `DESCRIPTION` to Git.                                                          | Release                             |
| `tag_version()`       | Parses `NEWS.md` and creates/updates the tag for the most recent version.                            | Release                             |
| `update_news()`       | Update `NEWS.md` with messages from top level commits                                                | Used by `bump_version()`            |
| `update_version()`    | Update `NEWS.md` and `DESCRIPTION` with a new version                                                | Used by `bump_version()`            |

## Usage

The following sections show, how to combine these functions at different
stages with any R package on GitHub. All {fledge} commands should be
issued from the package directory of the target R package.

### Initial Configuration

{fledge} assumes that the target R package is version-controlled with
Git in a dedicated repository. The following steps are required to set
up {fledge} for first time use, with your package.

1.  Call `bump_version()` as given below to set the package version

        fledge::bump_version()

2.  Call `finalize_version()` as given below to update `NEWS.md`

        fledge::finalize_version()

You are all set to switch to the development stage now. Ensure that you
use bullet points (`*` or `-`) in your commit or merge messages to
indicate the messages that you want to include in `NEWS.md`.

### Development

{fledge} aims to update `NEWS.md` and `DESCRIPTION` correctly whenever a
new version is assigned. In order to do this, the following steps need
to be included throughout the development workflow.

1.  In commit messages to master, mark everything that should go to
    `NEWS.md` with a bullet point (`-` or `*`). This is applicable to
    single commits, merge commits, or pull requests. Do not edit
    `NEWS.md` manually.

2.  When you want to assign a version number to the current state of
    your R package, call

    ``` r
    fledge::bump_version()
    ```

    The default argument for bump\_version is “dev”. So the dev part of
    the version number will be updated. It is good practice to assign a
    new version number before switching focus to another project.

3.  Edit `NEWS.md` if required. Then call `finalize_version()` as below.

    ``` r
    fledge::finalize_version()
    ```

    This achieves the following:

         * `NEWS.md` is now composed, based on the most recent commit messages.
             To understand how `NEWS.md` is updated by fledge, see the section on `NEWS.md` implementation.
         * A new version number is assigned automatically (this is modeled after `usethis::use_version()`)
         * A tag matching the version number is assigned automatically, with the most recent `NEWS.md` messages included in the tag's message.

### Releasing to CRAN

When you want to release your package to CRAN, follow the steps below:

1.  Call bump\_version() with the appropriate argument (`"patch"`,
    `"major"`, `"minor"`). e.g.,

    ``` r
    fledge::bump_version("patch")
    ```

2.  Edit `NEWS.md`, convert the “change log” to “release notes” – a
    higher-level description of features and bug fixes.

3.  Call `commit_version()` as below

    ``` r
    fledge::commit_version()
    ```

4.  Make any necessary adjustments before releasing to CRAN.

5.  Once the release/changes have been accepted by CRAN, use the
    following calls to tag the released version and to switch to a
    development version immediately.

        fledge::tag_version()
        fledge::bump_version()

## Implementation

The following sections explain, how things actually work inside fledge

### Updating `NEWS.md`

New entries are added to `NEWS.md` from commit messages to commits in
`master`.

-   Only top-level commits are considered (roughly equivalent to
    `git log --first-parent`.) The messages from these commits are
    parsed. Only lines that start with a star `*` or a dash `-` are
    included.

-   If a line starts with three dashes, then everything past that line
    is excluded. Example: the following commit message

        Merge f-fancy-feature to master, closes #5678

        - Added fancy feature (#5678).

        - Fixed bug as a side effect (#9012).

        ---

        The fancy feature consists of the components:

        - foo
        - bar
        - baz

    will be added as below to `NEWS.md`:

        - Added fancy feature (#5678).
        - Fixed bug as a side effect (#9012).

When retrieving the current NEWS for defining the tag message, the
entries between the first two first-level headers (starting with `#`)
are returned. You can use second and third level headers and add as many
empty lines as you want.

### Collecting NEWS

The first function to call at any stage is always `bump_version()`. This
does the following

1.  Calls `update_news()` to collect NEWS entries from top-level
    commits.

2.  Calls `update_version()` to increment the version in `DESCRIPTION`
    and add a header to `NEWS.md`.

### Tagging for “dev” vs. other releases

`bump_version()` continues depending on the release type:

-   `"dev"` releases: Calls `finalize_version()` to commit `DESCRIPTION`
    and `NEWS.md`. Also creates a tag with a message. You can always
    edit `NEWS.md` and call `finalize_version()` again. Both the commit
    and the tag will be updated.
-   Other releases: Calls `commit_version()` to commit `DESCRIPTION` and
    `NEWS.md` without tagging. In this stage, you can edit `NEWS.md` and
    commit as much as you like. The tag is created only after you use
    `tag_version()` manually.

## Caveats

If you rebase after creating a tag, you need to call
`finalize_version()` to make sure the tag is moved to the mainline
branch.

If you pushed after calling `finalize_version()` (directly or
indirectly), the tag may have been pushed as well. In this case, invoke

``` sh
git push origin :vx.y.z.9www
```

(where `x.y.z.9www` is the new version) to delete the newly created
remote tag. This is the reason why {fledge} only tags `"dev"` releases
automatically. Other releases always must be tagged manually with
`tag_version()`.
