% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_influence.R
\name{augment}
\alias{augment}
\title{Augment a \code{modeler} object with influence diagnostics}
\usage{
augment(x, id = NULL, metadata = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{modeler}.}

\item{id}{Optional unique identifier to filter by a specific group. Default is \code{NULL}.}

\item{metadata}{Logical. If \code{TRUE}, metadata is included with the predictions. Default is \code{FALSE}}

\item{...}{Additional parameters for future functionality.}
}
\value{
A tibble containing the following columns:
  \item{uid}{Unique identifier for the group.}
  \item{fn_name}{Function name associated with the model.}
  \item{x}{Predictor variable values.}
  \item{y}{Observed response values.}
  \item{.fitted}{Fitted values from the model.}
  \item{.resid}{Raw residuals (observed - fitted).}
  \item{.hat}{Leverage values for each observation.}
  \item{.cooksd}{Cook's distance for each observation.}
  \item{.std.resid}{Standardized residuals.}
  \item{.stud.resid}{Studentized residuals.}
}
\description{
This function computes various influence diagnostics, including
 standardized residuals, studentized residuals, and Cook's distance, for an
 object of class \code{modeler}.
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_logistic",
    parameters = c(a = 0.199, t0 = 47.7, k = 100),
    subset = 2
  )
print(mod_1)
augment(mod_1)
}
\author{
Johan Aparicio [aut]
}
