% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_confint.R
\name{confint.modeler}
\alias{confint.modeler}
\title{Confidence intervals for a modeler object}
\usage{
\method{confint}{modeler}(object, parm = NULL, level = 0.95, id = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{modeler}, typically the result of calling
the \code{modeler()} function.}

\item{parm}{A character vector specifying which parameters should have
confidence intervals calculated. If \code{NULL}, confidence intervals for all
parameters are returned. Default is \code{NULL}.}

\item{level}{A numeric value indicating the confidence level for the intervals.
Default is 0.95, corresponding to a 95\% confidence interval.}

\item{id}{An optional unique identifier to filter by a specific group.
Default is \code{NULL}.}

\item{...}{Additional parameters for future functionality.}
}
\value{
A \code{tibble} containing the lower and upper confidence limits for
each specified parameter.
}
\description{
Extract confidence intervals for the estimated parameters of an
object of class \code{modeler}.
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 35, 45)
  )
print(mod_1)
confint(mod_1)
}
\author{
Johan Aparicio [aut]
}
