% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_modeler.R
\name{modeler}
\alias{modeler}
\title{Modeler: Non-linear regression for curve fitting}
\usage{
modeler(
  data,
  x,
  y,
  grp,
  keep,
  fn = "fn_lin_plat",
  parameters = NULL,
  lower = -Inf,
  upper = Inf,
  fixed_params = NULL,
  method = c("subplex", "pracmanm", "anms"),
  subset = NULL,
  options = modeler.options(),
  control = list()
)
}
\arguments{
\item{data}{A \code{data.frame} containing the input data for analysis.}

\item{x}{The name of the column in \code{data} representing the independent variable (x points).}

\item{y}{The name of the column in \code{data} containing the dependent variable to analyze (response variable).}

\item{grp}{Column(s) in \code{data} used as grouping variable(s). Defaults to \code{NULL}. (Optional)}

\item{keep}{Names of columns to retain in the output. Defaults to \code{NULL}. (Optional)}

\item{fn}{A string. The name of the function used for curve fitting.
Example: \code{"fn_lin"}. Defaults to \code{"fn_lin_plat"}.}

\item{parameters}{A numeric vector, named list, or \code{data.frame} providing initial values for parameters:
\describe{
  \item{Numeric vector}{Named vector specifying initial values (e.g., \code{c(k = 0.5, t1 = 30)}).}
  \item{Data frame}{Requires a \code{uid} column with group IDs and parameter values for each group.}
  \item{List}{Named list where parameter values can be numeric or expressions (e.g., \code{list(k = "max(y)", t1 = 40)}).}
}
Defaults to \code{NULL}.}

\item{lower}{A numeric vector specifying lower bounds for parameters. Defaults to \code{-Inf} for all parameters.}

\item{upper}{A numeric vector specifying upper bounds for parameters. Defaults to \code{Inf} for all parameters.}

\item{fixed_params}{A list or \code{data.frame} for fixing specific parameters:
\describe{
  \item{List}{Named list where parameter values can be numeric or expressions (e.g., \code{list(k = "max(y)", t1 = 40)}).}
  \item{Data frame}{Requires a \code{uid} column for group IDs and fixed parameter values.}
}
Defaults to \code{NULL}.}

\item{method}{A character vector specifying optimization methods.
Check available methods using \code{list_methods()} and their dependencies using
\code{optimx::checkallsolvers()}. Defaults to \code{c("subplex", "pracmanm", "anms")}.}

\item{subset}{A vector (optional) containing levels of \code{grp} to filter the data for analysis.
Defaults to \code{NULL} (all groups are included).}

\item{options}{A list of additional options. See \code{modeler.options()}
\describe{
  \item{\code{progress}}{Logical. If \code{TRUE} a progress bar is displayed. Default is \code{FALSE}. Try this before running the function: \code{progressr::handlers("progress", "beepr")}.}
  \item{\code{parallel}}{Logical. If \code{TRUE} the model fit is performed in parallel. Default is \code{FALSE}.}
  \item{\code{workers}}{The number of parallel processes to use. \code{parallel::detectCores()}}
  \item{\code{trace}}{If \code{TRUE} , convergence monitoring of the current fit is reported in the console. \code{FALSE} by default.}
  \item{\code{return_method}}{ Logical. If \code{TRUE}, includes the optimization method used in the result. Default is \code{FALSE}.}
}}

\item{control}{A list of control parameters to be passed to the optimization function. For example: \code{list(maxit = 500)}.}
}
\value{
An object of class \code{modeler}, which is a list containing the following elements:
\describe{
  \item{\code{param}}{Data frame containing optimized parameters and related information.}
  \item{\code{dt}}{Data frame with input data, fitted values, and residuals.}
  \item{\code{metrics}}{Metrics and summary of the models.}
  \item{\code{execution}}{Total execution time for the analysis.}
  \item{\code{response}}{Name of the response variable analyzed.}
  \item{\code{keep}}{Metadata retained based on the \code{keep} argument.}
  \item{\code{fun}}{Name of the curve-fitting function used.}
  \item{\code{parallel}}{List containing parallel execution details (if applicable).}
  \item{\code{fit}}{List of fitted models for each group.}
}
}
\description{
A versatile function for performing non-linear least squares optimization on grouped data.
It supports customizable optimization methods, flexible initial/fixed parameters, and parallel processing.
}
\examples{
library(flexFitR)
data(dt_potato)
explorer <- explorer(dt_potato, x = DAP, y = c(Canopy, GLI), id = Plot)
# Example 1
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = GLI,
    grp = Plot,
    fn = "fn_lin_pl_lin",
    parameters = c(t1 = 38.7, t2 = 62, t3 = 90, k = 0.32, beta = -0.01),
    subset = 195
  )
plot(mod_1, id = 195)
print(mod_1)
# Example 2
mod_2 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = 195
  )
plot(mod_2, id = 195)
print(mod_2)
}
